<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
//navigation
$routes->get('/', 'Home::index');
$routes->get('login', 'Home::login');

//session
$routes->post('signin', 'Home::signin');
$routes->get('logout', 'Home::logout');

//dashboard
$routes->get('/dashboard', 'Dashboard::index');

//create user 
$routes->post('/users/create', 'LogicUser::createUser');

//get all students
$routes->get('logicuser/getUsersByRoleOne', 'LogicUser::getUsersByRoleOne');

//delete students
$routes->post('users/deactivate/(:num)', 'LogicUser::deactivateUser/$1');

//get groups for form 
$routes->get('logicuser/getActiveGroups', 'LogicUser::getActiveGroups');

//get total students
$routes->get('logicuser/getTotalStudentsByRoleOne', 'LogicUser::getTotalStudentsByRoleOne');

//view of recordedclasses
$routes->get('recordedclasses', 'Material\Recordedclasses::index');

//get recorded classes 
$routes->get('/material/recordedclasses', 'Material\Recordedclasses::index');

//delete recorded classes 
$routes->get('/material/recordedclasses/delete/(:num)', 'Material\Recordedclasses::delete/$1');

//add recorded classes 
$routes->post('material/recordedclasses/add', 'Material\Recordedclasses::add');

//create new group 
$routes->post('logicuser/createGroup', 'LogicUser::createGroup');

//delete group 
$routes->post('logicuser/deactivateGroup/(:num)', 'LogicUser::deactivateGroup/$1');

//settings view 
$routes->get('/settings', 'Settings\Settings::index');

//settings ticket for new password 
$routes->post('/settings/createChangePasswordTicket', 'Settings\Settings::createChangePasswordTicket');

//settings ticket for contact us
$routes->post('/settings/createContactTicket', 'Settings\Settings::createContactTicket');

//settings ticket for suport 
$routes->post('/settings/createSupportTicket', 'Settings\Settings::createSupportTicket');
$routes->post('/settings/checkSupportRequest', 'Settings\Settings::checkSupportRequest');
//info view
$routes->get('info', 'InfoController::index');
$routes->post('InfoController/editUser', 'InfoController::editUser');

//views for tickets 
$routes->get('tickets', 'Tickets\Tickets::index');

//all type of tickets 
$routes->get('tickets/pending', 'Tickets\Tickets::getPendingTickets');

//complete ticket 
$routes->post('tickets/resolve', 'Tickets\Tickets::resolveTicket');
//change password of a ticket
$routes->post('tickets/changePassword', 'Tickets\Tickets::changePassword');

//test view
$routes->get('/test', 'TestController\TestController::index');
$routes->post('/test/createTest', 'TestController\TestController::createTest');
$routes->post('/test/updateTestStatus', 'TestController\TestController::updateTestStatus');

//Material educ view 
$routes->get('materialeduc', 'Material\MaterialController::index');

// Rutas para manejar Material
$routes->get('material/create', 'Material\MaterialController::create');
$routes->post('/material/store', 'Material\MaterialController::store');
$routes->get('material/edit/(:num)', 'Material\MaterialController::edit/$1');
$routes->post('material/update/(:num)', 'Material\MaterialController::update/$1');
$routes->post('material/delete/(:num)', 'Material\MaterialController::delete/$1');

//Assing questions 
$routes->post('/questions/assign', 'Questions\QuestionsController::assignQuestions');
$routes->get('/questions/assignView', 'Questions\QuestionsController::assignView');

//Create question 
$routes->post('questions/createQuestion', 'Questions\QuestionsController::createQuestion');

//Capture Question create function
$routes->post('questions/createCaptureQuestion', '\App\Controllers\Questions\QuestionsController::createCaptureQuestion');
$routes->get('questions/assign', '\App\Controllers\Questions\QuestionsController::assignQuestions');
//grammar question function create 
$routes->post('questions/createGrammarQuestion', 'Questions\QuestionsController::createGrammarQuestion');
//math questions create function 
$routes->post('questions/createMathQuestion', 'Questions\QuestionsController::createMathQuestion');
//categories questions create function 
$routes->post('questions/createCategoryQuestion', 'Questions\QuestionsController::createCategoryQuestion');

//create timeline questions
$routes->post('timeline/timelineCreateQuestion', 'Questions\TimelineQuestions::createQuestion'); // save timeline questions
$routes->post('timeline/saveEvents', 'Questions\TimelineQuestions::saveEvents'); // save timeline events
$routes->post('timeline/saveOrder', 'Questions\TimelineQuestions::saveOrder'); // save correct timeline answer
$routes->get('timeline/getEvents/(:num)', 'Questions\TimelineQuestions::getEvents/$1'); // get Timeline question events

//create multiple answer questions
$routes->post('questions/createMultipleAnswer', 'Questions\MultipleCorrectQuestions::createMultipleAnswer'); // save questions
//start exam student 
$routes->post('test/startTest', 'TestController\TestStart::startTest');
$routes->get('exam/startTest', 'TestController\TestStart::index');

//start type text student 
$routes->post('test/startTypeText', 'TestController\TypeTextController::startTest');
//submit answer grammar type
$routes->post('test/submitAnswers', 'TestController\TestStart::submitAnswers');
$routes->post('test/submitAnswer', 'TestController\TestStart::submitAnswer');

// Rutas para las preguntas matemáticas
$routes->post('test/submitAnswer', 'TestController\TestStart::submitAnswer'); // Ruta existente

$routes->post('math/submitAnswer', 'TestController\TypeMathController::submitAnswer');


//submit answer text type
$routes->post('typetext/submitAnswers', 'TestController\TypeTextController::submitAnswers');
$routes->post('typetext/submitAnswer', 'TestController\TypeTextController::submitAnswer');

$routes->get('test/getTestInfo/(:num)', 'TestController\TestController::getTestInfo/$1');
$routes->post('/test/AssignGroup', 'TestController\TestController::AssignGroup');
//submit answer timeline
$routes->post('timeline/submitAnswer', 'Questions\TimelineQuestions::submitAnswer');

$routes->post('categories/submitAnswer', 'TestController\TypeCategoriesController::submitAnswer');

