<?php

namespace App\Controllers;

use App\Models\UserModel;
use App\Models\ReviewsModel;
use CodeIgniter\Controller;

class Home extends BaseController
{

    public function index(){

        $reviewsModel = new ReviewsModel();

        $data['reviews'] = $reviewsModel->getReviews();
        return view('reviews', $data);
    }
    public function login()
    {
        if (!session()->is_logged) {
            return view('login');
        }
        return redirect()->route('dashboard');
       
    }

    public function signin(){
        if(!$this->validate([
            'Username' => 'required',
            'Password' =>  'required'
        ])){
            return redirect()->back()->with('errors', $this->validator->getErrors())->withInput();
        }

        $Usuario = trim($this->request->getVar('Username'));
        $Password = trim($this->request->getVar('Password'));
        
        $model = model('UserModel');

        if(!$user = $model->getUserBy('Matricula', $Usuario)){
            return redirect()->back()->with('error', 'Este usuario no se encuentra registrado en el sistema');
        }

        if(!password_verify($Password, $user->Password)){
            return redirect()->back()->with('error', 'Error en la contraseña');
        }
        
        session()->set([
            'PK_User' => $user->PK_User,
            'Username' =>  $user->Name.' '.$user->LastName,
            'FK_Rol' => $user->FK_Rol,
            'Matricula' => $user->Matricula,
            'PhoneNumber' => $user->PhoneNumber,
            'Usuario' => $user->Usuario,
            'FK_Rol' => $user->FK_Rol,
            'EmergencyNumber' => $user->EmergencyNumber,
            'BirthDate' => $user->BirthDate,
            'FK_Group' => $user->FK_Group,
            'is_logged' => true
        ]);
        
        return redirect()->to('/dashboard')->with('success', 'Inicio de sesión exitoso.');

    }

    public function logout(){
        session()->destroy();
        return redirect()->route('/');
    }
    
}
