<?php

namespace App\Controllers;

use App\Models\OwnerModel;
use CodeIgniter\Controller;

class InfoController extends BaseController
{
    public function index(){
        if (!session()->is_logged) {
            return view('login');
        }
        $ownerModel = new OwnerModel();

        $data['owner'] = $ownerModel->getUser();
        return view('info', $data);
    }

    public function editUser(){
        $ownerModel = new OwnerModel();
    
        // Recibir los datos del formulario
        $email = $this->request->getPost('Email');
        $phonenumber = $this->request->getPost('PhoneNumber');
        $url = $this->request->getPost('Url');
        $birthdate = $this->request->getPost('BirthDate');
        $languages = $this->request->getPost('Languages');
        $city = $this->request->getPost('City');
        $university = $this->request->getPost('University');
        $major = $this->request->getPost('Major');
        $xp = $this->request->getPost('YearOfXp');
    
        // Datos del usuario que se van a actualizar, pero solo si no están vacíos
        $data = ['PK_Owner' => 1]; // Asegúrate de incluir la clave primaria para identificar al usuario
    
        if (!empty($email)) {
            $data['Email'] = $email;
        }
        if (!empty($phonenumber)) {
            $data['PhoneNumber'] = $phonenumber;
        }
        if (!empty($url)) {
            $data['Url'] = $url;
        }
        if (!empty($birthdate)) {
            $data['BirthDate'] = $birthdate;
        }
        if (!empty($languages)) {
            $data['Languages'] = $languages;
        }
        if (!empty($city)) {
            $data['City'] = $city;
        }
        if (!empty($university)) {
            $data['University'] = $university;
        }
        if (!empty($major)) {
            $data['Major'] = $major;
        }
        if (!empty($xp)) {
            $data['YearOfXp'] = $xp;
        }
    
        // Si no hay campos para actualizar, no se ejecuta la actualización
        if (count($data) > 1) { 
            if ($ownerModel->update(1, $data)) {
                return redirect()->back()->with('success', 'Datos Actualizados');
            } else {
                return redirect()->back()->with('error', 'Error al actualizar los datos');
            }
        } else {
            return redirect()->back()->with('info', 'No se han proporcionado datos para actualizar');
        }
    }
}