<?php

namespace App\Controllers;

use App\Models\UserModel;
use CodeIgniter\Controller;
use CodeIgniter\HTTP\ResponseInterface;
use App\Entities\User; 
use App\Models\GroupModel;

class LogicUser extends Controller
{
    public function createUser()
    {
        $userModel = new UserModel();
        
        // Crear una nueva instancia de la entidad User
        $userEntity = new User();
        
        // Asignar los valores al objeto de la entidad
        $userEntity->Name = $this->request->getPost('name');
        $userEntity->LastName = $this->request->getPost('lastName');
        $userEntity->Matricula = $this->request->getPost('matricula');
        $userEntity->Password = $this->request->getPost('password'); 
        $userEntity->FK_Group = $this->request->getPost('group'); 
    
        // Insertar el nuevo usuario usando la entidad
        if ($userModel->save($userEntity)) {
            return $this->response->setJSON(['success' => true]);
        } else {
            return $this->response->setJSON(['success' => false, 'message' => 'Error al crear el usuario'], ResponseInterface::HTTP_BAD_REQUEST);
        }
    }
    
    // Nueva función para obtener todos los usuarios con FK_Rol = 1
    public function getUsersByRoleOne()
    {
        $userModel = new UserModel();
    
        // Obtener los usuarios con FK_Rol = 1 y limitar a 3
        $users = $userModel->getUsersByRoleOne();
    
        // Limitar a los primeros 3 resultados si es necesario
        $limitedUsers = array_slice($users, 0, 2);
    
        // Comprobar si hay usuarios
        if (!empty($limitedUsers)) {
            return $this->response->setJSON(['success' => true, 'users' => $limitedUsers]);
        } else {
            return $this->response->setJSON(['success' => false, 'message' => 'No se encontraron usuarios con FK_Rol = 1'], ResponseInterface::HTTP_NOT_FOUND);
        }
    }
    

    public function deactivateUser($id)
    {
        $userModel = new UserModel();
    
        // Verificar si el usuario existe antes de desactivarlo
        $user = $userModel->find($id);
        if ($user) {
            $user->Status = 0; // Cambiar el estado a 0 (inactivo)
            if ($userModel->save($user)) {
                return $this->response->setJSON(['success' => true, 'message' => 'Usuario dado de baja correctamente']);
            } else {
                return $this->response->setJSON(['success' => false, 'message' => 'Error al dar de baja al usuario'], ResponseInterface::HTTP_BAD_REQUEST);
            }
        } else {
            return $this->response->setJSON(['success' => false, 'message' => 'Usuario no encontrado'], ResponseInterface::HTTP_NOT_FOUND);
        }
    }
    
     // Función para obtener todos los grupos activos
    public function getActiveGroups()
    {
        $groupModel = new GroupModel();

        // Obtener todos los grupos activos
        $groups = $groupModel->getActiveGroups();

        // Comprobar si hay grupos y hacer log de lo que devuelve
        if (!empty($groups)) {
            log_message('info', 'Grupos activos obtenidos: ' . json_encode($groups));
            return $this->response->setJSON(['success' => true, 'groups' => $groups]);
        } else {
            log_message('error', 'No se encontraron grupos activos.');
            return $this->response->setJSON(['success' => false, 'message' => 'No se encontraron grupos activos'], ResponseInterface::HTTP_NOT_FOUND);
        }
    }

    //Contador para total de alumnos
    public function getTotalStudentsByRoleOne()
    {
        $userModel = new \App\Models\UserModel();
        $totalStudents = $userModel->countUsersByRoleOne();
    
        // Capacidad máxima de alumnos
        $maxCapacity = 50;
    
        // Cálculo del porcentaje
        $percentage = ($totalStudents / $maxCapacity) * 100;
    
        return $this->response->setJSON([
            'total' => $totalStudents,
            'percentage' => round($percentage) // Redondear a un número entero
        ]);
    }
    
    public function createGroup()
    {
        $groupModel = new GroupModel();
    
        // Obtener los datos enviados como JSON
        $json = $this->request->getJSON();
    
        // Extraer los valores de JSON
        $groupName = $json->GroupName ?? null;
        $description = $json->Description ?? null;
    
        // Verificar si los valores han sido proporcionados
        if (!$groupName || !$description) {
            return $this->response->setJSON(['success' => false, 'message' => 'Faltan campos requeridos']);
        }
    
        // Preparar los datos para insertar
        $groupData = [
            'GroupName' => $groupName,
            'Description' => $description,
            'CreatedAt' => date('Y-m-d H:i:s'),
            'UpdatedAt' => date('Y-m-d H:i:s'),
            'Status' => 1 // Activo por defecto
        ];
    
        // Guardar el nuevo grupo
        if ($groupModel->insert($groupData)) {
            return $this->response->setJSON(['success' => true]);
        } else {
            return $this->response->setJSON(['success' => false, 'message' => 'Error al crear el grupo']);
        }
    }

    public function getGroups()
{
    $groupModel = new GroupModel();

    $groups = $groupModel->findAll();

    if (!empty($groups)) {
        return $this->response->setJSON(['success' => true, 'groups' => $groups]);
    } else {
        return $this->response->setJSON(['success' => false, 'message' => 'No se encontraron grupos']);
    }
}

public function deactivateGroup($id)
{
    $groupModel = new GroupModel();

    // Verificar si el grupo existe antes de desactivarlo
    $group = $groupModel->find($id);
    if ($group) {
        $group['Status'] = 0; // Cambiar el estado a 0 (inactivo)
        if ($groupModel->save($group)) {
            return $this->response->setJSON(['success' => true, 'message' => 'Grupo desactivado correctamente']);
        } else {
            return $this->response->setJSON(['success' => false, 'message' => 'Error al desactivar el grupo']);
        }
    } else {
        return $this->response->setJSON(['success' => false, 'message' => 'Grupo no encontrado']);
    }
}



}
