<?php

namespace App\Controllers\Material;

use App\Models\MaterialModel;
use App\Models\MaterialUsersModel; 
use App\Models\GroupModel;
use CodeIgniter\Controller;

class MaterialController extends Controller
{
    protected $materialModel;
    protected $session;

    public function __construct()
    {
        $this->materialModel = new MaterialModel();
        $this->materialUsersModel = new MaterialUsersModel(); 
        $this->session = session();
    }

    // Función para mostrar todos los materiales
    public function index()
    {
        // Verificar si el usuario está logueado
        if (!session()->get('is_logged')) {
            return redirect()->to('/login');  // Redirigir al login si no está logueado
        }
    
        // Obtener todos los materiales desde la vista v_material_allusers
        $materials = $this->materialUsersModel->orderBy('CreatedAt', 'DESC')->findAll();
    
        // Obtener los grupos activos
        $groupModel = new GroupModel();
        $groups = $groupModel->getActiveGroups();
    
        // Pasar los materiales y los grupos a la vista
        return view('material/materialeduc', ['materials' => $materials, 'groups' => $groups]);
    }
    

    // Función para crear un nuevo material
    public function create()
    {
        return view('material/create');
    }

    // Función para guardar un nuevo material
    public function store()
    {
        // Decodificar JSON si el Content-Type es application/json
        $input = $this->request->getJSON(true); // Decodificar como array
        
        $data = [
            'Name' => $input['name'],
            'Link' => $input['link'],
            'FK_Group' => $input['group'],
            'Status' => 1,
            'CreatedAt' => date('Y-m-d H:i:s'),
            'UpdatedAt' => date('Y-m-d H:i:s')
        ];
    
        if ($this->materialModel->save($data)) {
            return $this->response->setJSON(['success' => true, 'message' => 'Material creado correctamente']);
        } else {
            return $this->response->setJSON(['success' => false, 'message' => 'Error al crear el material']);
        }
    }
    

    // Función para editar un material existente
    public function edit($id)
    {
        // Encontrar el material por su ID
        $material = $this->materialModel->find($id);
        
        if (!$material) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Material no encontrado');
        }
    
        // Obtener todos los grupos activos
        $groupModel = new \App\Models\GroupModel();
        $groups = $groupModel->getActiveGroups();
    
        // Pasar los datos del material y los grupos a la vista
        return view('material/edit', [
            'material' => $material,
            'groups' => $groups // Aquí pasamos los grupos a la vista
        ]);
    }
    
    

    public function update($id)
    {
        $data = [
            'Name' => $this->request->getPost('name'),
            'Link' => $this->request->getPost('link'),
            'FK_Group' => $this->request->getPost('group'),
            'Status' => 1,  
            'UpdatedAt' => date('Y-m-d H:i:s')
        ];
    
        if ($this->materialModel->update($id, $data)) {
            return $this->response->setJSON(['success' => true, 'message' => 'Material actualizado correctamente']);
        } else {
            return $this->response->setJSON(['success' => false, 'message' => 'Error al actualizar el material']);
        }
    }
    
    public function delete($id)
    {
        if ($this->materialModel->delete($id)) {
            return $this->response->setJSON(['success' => true, 'message' => 'Material eliminado correctamente']);
        } else {
            return $this->response->setJSON(['success' => false, 'message' => 'Error al eliminar el material']);
        }
    }
    
    
}
