<?php

namespace App\Controllers\Material;

use CodeIgniter\Controller;
use App\Models\RecordedclassesModel;
use App\Models\GroupModel;

class Recordedclasses extends Controller
{
    public function index()
    {
        // Verifica si el usuario está loggeado
        if (!session()->get('is_logged')) {
            return redirect()->to('/login');
        }
    
        // Obtener el valor del rol y del grupo desde la sesión del usuario
        $role = session()->get('FK_Rol');
        $groupId = session()->get('FK_Group');
    
        // Cargar el modelo de clases grabadas
        $model = new RecordedclassesModel();
    
        // Verificar el rol del usuario
        if ($role == 1) {
            // Si el rol es 1, traer solo las clases del grupo
            $data['classes'] = $model->getActiveClassesForGroup($groupId);
        } else if ($role == 2 || $role == 3) {
            // Si el rol es 2 o 3, traer todas las clases
            $data['classes'] = $model->getActiveClasses();
        }
    
        // Cargar la vista de clases grabadas, pasando los datos
        return view('material/recordedclasses', $data);
    }
    
    

    // Método para eliminar una clase grabada
    public function delete($id)
    {
        // Verifica si el usuario está loggeado
        if (!session()->get('is_logged')) {
            return redirect()->to('/login');
        }
    
        // Cargar el modelo de clases grabadas
        $model = new RecordedclassesModel();
    
        // Realizar la eliminación lógica de la clase
        $success = $model->softDeleteClass($id);
    
        // Devolver la respuesta como JSON
        return $this->response->setJSON(['success' => $success]);
    }

    
     // Función para obtener todos los grupos activos
    public function getActiveGroups()
    {
        $groupModel = new GroupModel();

         // Obtener todos los grupos activos
        $groups = $groupModel->getActiveGroups();

         // Comprobar si hay grupos y hacer log de lo que devuelve
        if (!empty($groups)) {
            log_message('info', 'Grupos activos obtenidos: ' . json_encode($groups));
            return $this->response->setJSON(['success' => true, 'groups' => $groups]);
        } else {
            log_message('error', 'No se encontraron grupos activos.');
            return $this->response->setJSON(['success' => false, 'message' => 'No se encontraron grupos activos'], ResponseInterface::HTTP_NOT_FOUND);
        }
    }

    public function add()
    {
        $json = $this->request->getJSON();

        $classData = [
            'ClassName' => $json->className,
            'Link' => $json->link,
            'FK_Group' => $json->group,
            'RecordedAt' => date('Y-m-d H:i:s'),
            'CreatedAt' => date('Y-m-d H:i:s'),
            'UpdatedAt' => date('Y-m-d H:i:s'),
            'Status' => 1
        ];

        $recordedClassesModel = new RecordedclassesModel();
        if ($recordedClassesModel->insert($classData)) {
            return $this->response->setJSON(['success' => true]);
        } else {
            return $this->response->setJSON(['success' => false]);
        }
    }

}
