<?php

namespace App\Controllers\Questions;

use App\Models\MultipleCorrect\MultipleCorrectQuestionModel;
use CodeIgniter\Controller;


class MultipleCorrectQuestions extends Controller
{
    public function createMultipleAnswer()
    {
        $questionModel = new MultipleCorrectQuestionModel();

        // Recibir los datos del formulario
        
        

       // Procesar la carga del material (si existe)
       $file = $this->request->getFile('Material');
       if ($file && $file->isValid() && !$file->hasMoved()) {
           // Mover el archivo a la carpeta 'public/Uploads/Material/'
            $newFileName = $file->getRandomName();
            $file->move(ROOTPATH . 'public/Uploads/Material', $newFileName);
            $material = 'Uploads/Material/' . $newFileName;  // Guardar la ruta completa en la base de datos
            $pktest = $this->request->getPost('TestId');
            $question = $this->request->getPost('Question');
            $instructions = $this->request->getPost('Instructions');
            $answers = $this->request->getPost('correctAnswer');
            $subject = $this->request->getPost('Subject');

            $answers = json_encode($answers);

            $data = [
                'FK_Test' => $pktest,
                'Question' => $question,
                'Instructions' => $instructions,
                'Subject' => $subject,
                'CorrectAnswers' => $answers,
                'Material' => $material
            ];
            
        }
        
        if ($questionModel->save($data)) {
            return $this->response->setJSON([
                'status' => 'success',
                'success' => true,
                'message' => 'Pregunta creada correctamente.'
            ]);
        } else {
            return $this->response->setJSON([
                'status' => 'error',
                'success' => false,
                'message' => 'Error al crear la pregunta.'
            ]);
        }
    }

}