<?php

namespace App\Controllers\Questions;

use App\Models\QuestionGrammarModel; 
use App\Models\TestModel;
use App\Models\QuestionTypeTextModel;
use App\Models\QuestionsxMathModel;
use App\Models\QuestionsCategories\QuestionsTypeCategoriesModel;
use App\Models\QuestionsCategories\QuestionCategoriesModel;
use App\Models\QuestionsCategories\QuestionOptionsModel;
use App\Models\QuestionsCategories\CategoryItemsModel;

use CodeIgniter\Controller;


class QuestionsController extends Controller
{
    public function assignQuestions()
    {
        if (!session()->get('is_logged')) {
            return redirect()->to('/login');
        }
    
        $role = session()->get('FK_Rol');
    
        // Si el rol es de alumno (1), redirigir al dashboard
        if ($role == 1) {
            return redirect()->to('/dashboard');
        }
    
        // Obtener el testId desde POST
        $testId = $this->request->getPost('testId'); // Lo hemos llamado testId en lugar de encryptedTestId
    
        // Verificar si se recibió correctamente el testId
        if (!$testId) {
            return redirect()->back()->with('error', 'ID del examen no válido.');
        }
    
        // Si quieres desencriptar en el futuro:
        // $testId = decrypt($testId); // Si es necesario
    
        // Pasar el testId a la vista
        return view('Questions/assign', ['testId' => $testId]);
    }
    
    // Función para crear preguntas gramaticales
    public function createGrammarQuestion()
    {
        if (!session()->get('is_logged')) {
            return $this->response->setJSON(['success' => false, 'error' => 'Usuario no autenticado.']);
        }

        $questionGrammarModel = new QuestionGrammarModel();

        // Obtener los datos del formulario
        $data = [
            'Question' => $this->request->getPost('question'),
            'CorrectAnswer' => $this->request->getPost('correctAnswer'),
            'Option1' => $this->request->getPost('option1'),
            'Option2' => $this->request->getPost('option2'),
            'Option3' => $this->request->getPost('option3'),
            'Option4' => $this->request->getPost('option4'),
            'Instructions' => $this->request->getPost('instructions'),  
            'Subject' => $this->request->getPost('subject'),
            'FK_Test' => $this->request->getPost('testId'),
            'TypeQuestion' => 'Gramatica'
        ];

        // Validar los datos y guardar en la base de datos
        if ($questionGrammarModel->save($data)) {
            return $this->response->setJSON(['success' => true, 'message' => 'Pregunta gramatical creada exitosamente.']);
        } else {
            return $this->response->setJSON(['success' => false, 'error' => $questionGrammarModel->errors()]);
        }
    }

    // Función existente para capturar preguntas
    public function createCaptureQuestion()
    {
        if (!session()->get('is_logged')) {
            return $this->response->setJSON(['success' => false, 'error' => 'Usuario no autenticado.']);
        }

        $questionModel = new QuestionTypeTextModel();

        // Validar si se seleccionó el tipo de pregunta "Captura la respuesta"
        if ($this->request->getPost('questionType') == 'captura_respuesta') {
            $data = [
                'Question' => $this->request->getPost('question'),
                'CorrectAnswer' => $this->request->getPost('correctAnswer'),
                'Instructions' => $this->request->getPost('Instructions'),
                'Subject' => $this->request->getPost('subject'),
                'FK_Test' => $this->request->getPost('testId'),
                'TypeQuestion' => 'Captura-Respuesta',
            ];

            // Procesar la carga del material (si existe)
            $file = $this->request->getFile('material');
            if ($file && $file->isValid() && !$file->hasMoved()) {
                // Mover el archivo a la carpeta 'public/Uploads/Material/'
                $newFileName = $file->getRandomName();
                $file->move(ROOTPATH . 'public/Uploads/Material', $newFileName);
                $data['UploadMaterial'] = 'Uploads/Material/' . $newFileName;  // Guardar la ruta completa en la base de datos
            }

            // Intentar guardar la pregunta
            if ($questionModel->save($data)) {
                return $this->response->setJSON(['success' => true]);
            } else {
                return $this->response->setJSON(['success' => false, 'error' => $questionModel->errors()]);
            }
        } else {
            return $this->response->setJSON(['success' => false, 'error' => 'Tipo de pregunta no soportado.']);
        }
    }
    public function createMathQuestion()
{
    if (!session()->get('is_logged')) {
        return $this->response->setJSON(['success' => false, 'error' => 'Usuario no autenticado.']);
    }

    $questionMathModel = new \App\Models\QuestionsMathModel();

    // Obtener los datos del formulario
    $data = [
        'Question' => $this->request->getPost('question'),
        'CorrectAnswer' => $this->request->getPost('correctAnswer'),
        'Option1' => $this->request->getPost('option1'),
        'Option2' => $this->request->getPost('option2'),
        'Option3' => $this->request->getPost('option3'),
        'Option4' => $this->request->getPost('option4'),
        'Instructions' => $this->request->getPost('instructions'),
        'Subject' => $this->request->getPost('subject'),
        'FK_Test' => $this->request->getPost('testId'),
        'TypeQuestion' => 'Matematicas'
    ];

    // Procesar la carga del material (si existe)
    $file = $this->request->getFile('material');
    if ($file && $file->isValid() && !$file->hasMoved()) {
        // Mover el archivo a la carpeta 'public/Uploads/MathAndFisic'
        $newFileName = $file->getRandomName();
        $file->move(ROOTPATH . 'public/Uploads/MathAndFisic', $newFileName);
        $data['UploadMaterial'] = 'Uploads/MathAndFisic/' . $newFileName;  // Guardar la ruta completa en la base de datos
    }

    // Validar los datos y guardar en la base de datos
    if ($questionMathModel->save($data)) {
        return $this->response->setJSON(['success' => true, 'message' => 'Pregunta de matemáticas creada exitosamente.']);
    } else {
        // Mostrar errores del modelo
        return $this->response->setJSON(['success' => false, 'error' => $questionMathModel->errors()]);
    }
}

public function createCategoryQuestion()
{
    if (!session()->get('is_logged')) {
        log_message('error', 'Usuario no autenticado.');
        return $this->response->setJSON(['success' => false, 'error' => 'Usuario no autenticado.']);
    }

    // Modelos para las tablas
    $categoryQuestionModel = new \App\Models\QuestionsCategories\QuestionsTypeCategoriesModel();
    $categoryModel = new \App\Models\QuestionsCategories\QuestionCategoriesModel();
    $itemsModel = new \App\Models\QuestionsCategories\CategoryItemsModel(); 

    // Obtener los datos del formulario para la pregunta
    $data = [
        'Question' => $this->request->getPost('question'),
        'CorrectAnswer' => $this->request->getPost('correctAnswer'),
        'Instructions' => $this->request->getPost('instructions'),
        'FK_Test' => $this->request->getPost('testId'),
        'TypeQuestion' => 'Categorias'
    ];

    log_message('info', 'Datos de pregunta recibidos: ' . json_encode($data));

    // Guardar la pregunta principal
    if ($categoryQuestionModel->save($data)) {
        $questionId = $categoryQuestionModel->insertID();
        log_message('info', "Pregunta creada con ID: {$questionId}");
        
        $fkTest = $data['FK_Test'];

        // Guardar las categorías y sus ítems
        $categories = [
            'category1' => $this->request->getPost('category1'),
            'category2' => $this->request->getPost('category2')
        ];

        foreach ($categories as $key => $categoryName) {
            if (!empty($categoryName)) {
                // Insertar categoría y obtener su ID
                $categoryData = [
                    'FK_Question' => $questionId,
                    'FK_Test' => $fkTest,
                    'Category' => $categoryName
                ];
                
                $categoryModel->insert($categoryData);
                $categoryId = $categoryModel->insertID();
        
                // Obtener los ítems como array usando el nombre de la categoría
                $items = $this->request->getPost('items_' . strtolower($key) . '[]');  // Cambia a minúscula si necesario
                
                log_message('info', "Items para {$categoryName}: " . print_r($items, true));
        
                if (is_array($items) && !empty($items)) {
                    foreach ($items as $item) {
                        if (!empty($item)) {
                            $itemsModel->insert([
                                'FK_Category' => $categoryId,
                                'Item' => $item,
                                'CreatedAt' => date('Y-m-d H:i:s')
                            ]);
                            log_message('info', "Insertado ítem: " . json_encode(['FK_Category' => $categoryId, 'Item' => $item]));
                        }
                    }
                } else {
                    log_message('error', "No se encontraron ítems para la categoría: {$categoryName}");
                }
            }
        }
        

        return $this->response->setJSON(['success' => true, 'message' => 'Pregunta de categorías creada exitosamente.']);
    } else {
        log_message('error', "Error al insertar la pregunta: " . json_encode($categoryQuestionModel->errors()));
        return $this->response->setJSON(['success' => false, 'error' => 'Error al crear la pregunta.']);
    }
}


}
