<?php

namespace App\Controllers\Questions;

use App\Models\TimelineQuestionTypeModel;
use App\Models\TimelineEventsModel;
use App\Models\TimelineCorrectOrderModel;
use App\Models\TimelineStudentAnswerModel;
use CodeIgniter\Controller;


class TimelineQuestions extends Controller
{
    public function createQuestion()
    {
        $timelineQuestionTypeModel = new TimelineQuestionTypeModel();


        $file = $this->request->getFile('TimelineMaterial');
        if ($file && $file->isValid() && !$file->hasMoved()) {
            $newFileName = $file->getRandomName();
            $file->move(ROOTPATH . 'public/Uploads/Material', $newFileName);
            $material = 'Uploads/Material/' . $newFileName;

            $id = $this->request->getPost('testId');
            $question = $this->request->getPost('timelineQuestion');
            $subject = $this->request->getPost('subjectQuestion');
            $instructions = $this->request->getPost('instructions');

            // Verificar si los campos están vacíos
            if (empty($id) || empty($question)) {
                return $this->response->setJSON([
                    'status' => 'error',
                    'message' => 'Por favor, completa todos los campos.'
                ]);
            }

             // Datos a insertar
            $data = [
                'FK_Test' => $id,
                'Question' => $question,
                'Subject' => $subject,
                'Instructions' => $instructions,
                'Material' => $material
            ];
        }
        //Insertar y obtener el ID
        if ($timelineQuestionTypeModel->insert($data)) {
            $pk_question = $timelineQuestionTypeModel->insertID(); // Obtener el ID insertado
            return $this->response->setJSON([
                'status' => 'success',
                'message' => 'Pregunta creada correctamente',
                'PK_Question' => $pk_question // Devolver el PK_Question
            ]);
        } else {
            return $this->response->setJSON([
                'status' => 'error',
                'message' => 'Error al crear la pregunta'
            ]);
        }
    }

    public function saveEvents()
    {
        $eventsModel = new TimelineEventsModel();

        // Recibir los datos del formulario
        $questionId = $this->request->getPost('questionId');
        $timelineQuestions = $this->request->getPost('timelineQuestion');

        $success = true; // Variable para rastrear el estado de éxito
        $responses = []; // Array para almacenar respuestas de inserción

        // Procesar cada evento
        foreach ($timelineQuestions as $event) {
            $result = $eventsModel->insert([
                'FK_Timeline_Question' => $questionId, // Almacena el ID de la pregunta
                'Event_Description' => $event, // Almacena la descripción del evento
            ]);

            // Verificar si la inserción fue exitosa
            if (!$result) {
                $success = false; // Cambiar a false si alguna inserción falla
                $responses[] = [
                    'event' => $event,
                    'status' => 'error',
                    'message' => 'Error al guardar el evento: ' . $eventsModel->errors() // Almacenar el error
                ];
            } else {
                $responses[] = [
                    'event' => $event,
                    'status' => 'success',
                ];
            }
        }

        // Devolver una respuesta JSON basada en el resultado de las inserciones
        if ($success) {
            return $this->response->setJSON(['status' => 'success' ,'success' => true, 'message' => 'Todos los eventos fueron guardados correctamente.', 'responses' => $responses]);
        } else {
            return $this->response->setJSON(['status' => 'warning', 'success' => false, 'message' => 'Algunos eventos no se guardaron.', 'responses' => $responses]);
        }
    }

    public function getEvents($pk)
        {
        $eventsModel = new TimelineEventsModel();
        $events = $eventsModel->getEventsByTimelineQuestion($pk);
        echo json_encode($events);
    }

    public function saveOrder()
    {
        $correctModel = new TimelineCorrectOrderModel();

        // Recibir los datos del formulario
        $events = $this->request->getPost('FK_Event'); // Array de eventos
        $order = $this->request->getPost('Correct_Order'); // Array de órdenes
        $question = $this->request->getPost('FK_Question'); // ID de la pregunta

        $success = true; // Variable para rastrear el estado de éxito
        $responses = []; // Array para almacenar respuestas de inserción
        // // Asegurar que la cantidad de eventos y órdenes coincida
        if (count($events) !== count($order)) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'La cantidad de eventos no coincide con la cantidad de órdenes.']);
        }

        // Procesar cada evento junto con su orden respectivo
        foreach ($events as $index => $event) {
            $currentOrder = $order[$index]; // Obtener el valor de orden correspondiente al evento actual
            $questionID = $question[$index];
            $result = $correctModel->insert([
                'FK_Question' => $questionID, // Almacena el ID de la pregunta
                'FK_Event' => $event,       // Almacena la descripción del evento
                'Correct_Order' => $currentOrder,    // Almacena el orden correcto para el evento
            ]);

            // Verificar si la inserción fue exitosa
            if (!$result) {
                $success = false; // Cambiar a false si alguna inserción falla
                $responses[] = [
                    'event' => $event,
                    'status' => 'error',
                    'message' => 'Error al guardar el evento: ' . $correctModel->errors() // Almacenar el error
                ];
            } else {
                $responses[] = [
                    'event' => $event,
                    'order' => $currentOrder,
                    'status' => 'success',
                ];
            }
        }

        // Devolver una respuesta JSON basada en el resultado de las inserciones
        if ($success) {
            return $this->response->setJSON([
                'status' => 'success',
                'success' => true,
                'message' => 'Todos los eventos fueron guardados correctamente.',
                'responses' => $responses
            ]);
        } else {
            return $this->response->setJSON([
                'status' => 'warning',
                'success' => false,
                'message' => 'Algunos eventos no se guardaron.',
                'responses' => $responses
            ]);
        }
    }

    public function submitAnswer()
        {
            // Verificar si el usuario está logueado
            if (!session()->get('is_logged')) {
                return $this->response->setJSON(['success' => false, 'error' => 'Usuario no autenticado.']);
            }
        
            // Obtener los datos enviados desde el formulario
            $eventId = $this->request->getPost('FK_Event');
            $userId = $this->request->getPost('PK_User');
            $questionId = $this->request->getPost('FK_Question');
            $answer = $this->request->getPost('Answer');
        
            // Verificar que se hayan recibido los datos
            if (empty($eventId) || empty($userId) || empty($questionId) || empty($answer)) {
                return $this->response->setJSON(['success' => false, 'error' => 'Datos incompletos']);
            }
        
            // Crear una instancia del modelo de respuestas
            $answersModel = new TimelineStudentAnswerModel();
        
            // Insertar la respuesta en la base de datos
            $data = [
                'FK_Event' => $eventId,
                'FK_User' => $userId,
                'FK_Question' => $questionId,
                'Answer_Order' => $answer
            ];
        
            if ($answersModel->insert($data)) {
                return $this->response->setJSON(['success' => true, 'message' => 'Respuesta enviada correctamente.']);
            } else {
                return $this->response->setJSON(['success' => false, 'error' => 'Error al guardar la respuesta.']);
            }
        }

}