<?php

namespace App\Controllers\Settings;

use CodeIgniter\Controller;
use App\Models\TicketsModel;
use App\Models\UserModel;
use App\Models\GroupModel;


class Settings extends Controller
{
    public function index()
    {
        // Verificar si el usuario está logueado
        if (!session()->get('is_logged')) {
            return redirect()->to('/login');
        }
    
        // Verificar el rol del usuario (Solo Maestro y Admin)
        $role = session()->get('FK_Rol');
        if ($role == 2 || $role == 3) {
            $userModel = new UserModel();
            $groupModel = new GroupModel();
    
            // Obtener la lista de alumnos con solo nombre, matrícula y fecha de registro
            $data['students'] = $userModel->getStudentsSummary();
    
            // Obtener los últimos 5 grupos activos
            $data['groups'] = $groupModel->getRecentActiveGroups();  // Asegúrate de pasar el límite aquí
    
            // Cargar la vista de settings para Maestro y Admin con los datos de los alumnos y grupos
            return view('settings/settings', $data);
        }
    
        // Si no es maestro o admin, redirigir o cargar una vista diferente
        return redirect()->to('/login');
    }
    
    public function createChangePasswordTicket()
    {
        // Verificar si el usuario está logueado
        if (!session()->get('is_logged')) {
            return $this->response->setJSON(['success' => false, 'message' => 'Usuario no loggeado']);
        }
    
        // Obtener el PK_User desde la sesión
        $userId = session()->get('PK_User');
    
        // Cargar el modelo de tickets
        $ticketsModel = new TicketsModel();
    
        // Verificar si ya existe un ticket de cambio de contraseña pendiente o en proceso
        $existingTicket = $ticketsModel
            ->where('FK_User', $userId)
            ->where('Category', 'NuevaContraseña')
            ->whereIn('Status', ['Pendiente', 'En proceso']) // Verificar si el estado está en Pendiente o En proceso
            ->first();
    
        if ($existingTicket) {
            return $this->response->setJSON(['success' => false, 'message' => 'Ya tienes una solicitud de cambio de contraseña en proceso.']);
        }
    
        // Obtener los datos del request
        $json = $this->request->getJSON();
    
        // Crear los datos del ticket
        $ticketData = [
            'FK_User' => $userId,
            'Category' => 'NuevaContraseña',  
            'Priority' => 'Alta',  
            'Reason' => 'Solicito un cambio de contraseña',  
            'CreatedAt' => date('Y-m-d H:i:s'),
            'Status' => 'Pendiente'  
        ];
    
        // Intentar insertar el ticket
        if ($ticketsModel->insert($ticketData)) {
            return $this->response->setJSON(['success' => true, 'message' => 'Ticket creado exitosamente']);
        } else {
            // Obtener el error generado por el modelo
            $errors = $ticketsModel->errors();
            return $this->response->setJSON(['success' => false, 'message' => 'Error al crear el ticket', 'errors' => $errors]);
        }
    }
    
    public function createContactTicket()
    {
        // Verificar si el usuario está loggeado
        if (!session()->get('is_logged')) {
            return $this->response->setJSON(['success' => false, 'message' => 'Usuario no loggeado']);
        }
    
        // Obtener el userId desde la sesión
        $userId = session()->get('PK_User');  // Usar PK_User para coincidir con la variable de sesión
    
        if (!$userId) {
            return $this->response->setJSON(['success' => false, 'message' => 'ID de usuario no disponible']);
        }
    
        // Obtener los datos del request
        $json = $this->request->getJSON();
    
        // Verificar si el email y el teléfono están presentes
        if (empty($json->email) || empty($json->phone)) {
            return $this->response->setJSON(['success' => false, 'message' => 'Email y teléfono son obligatorios']);
        }
    
        // Crear los datos del ticket con la información de contacto en Comments
        $ticketData = [
            'FK_User' => $userId, 
            'Category' => 'Consulta-general', 
            'Priority' => 'Baja',  
            'Reason' => 'Consulta sobre contacto',  // Un motivo general para esta categoría
            'Comments' => "Email: {$json->email}, Teléfono: {$json->phone}",  // Guardamos el email y teléfono
            'CreatedAt' => date('Y-m-d H:i:s'),
            'Status' => 'Pendiente'  
        ];
    
        // Cargar el modelo de tickets
        $ticketsModel = new TicketsModel();
    
        // Intentar insertar el ticket
        if ($ticketsModel->insert($ticketData)) {
            return $this->response->setJSON(['success' => true, 'message' => 'Ticket creado exitosamente']);
        } else {
            // Obtener el error generado por el modelo
            $errors = $ticketsModel->errors();
            return $this->response->setJSON(['success' => false, 'message' => 'Error al crear el ticket', 'errors' => $errors]);
        }
    }
    
    public function createSupportTicket()
    {
        // Verificar si el usuario está loggeado
        if (!session()->get('is_logged')) {
            return $this->response->setJSON(['success' => false, 'message' => 'Usuario no loggeado']);
        }
    
        // Obtener el userId desde la sesión
        $userId = session()->get('PK_User');
    
        if (!$userId) {
            return $this->response->setJSON(['success' => false, 'message' => 'ID de usuario no disponible']);
        }
    
        // Verificar si ya existe un ticket de soporte enviado en las últimas 24 horas
        $ticketsModel = new TicketsModel();
        $oneDayAgo = date('Y-m-d H:i:s', strtotime('-1 day'));
    
        $existingTicket = $ticketsModel
            ->where('FK_User', $userId)
            ->where('Category', 'Soporte')
            ->where('CreatedAt >=', $oneDayAgo)
            ->first();
    
        if ($existingTicket) {
            return $this->response->setJSON(['success' => false, 'message' => 'Ya has enviado una solicitud de soporte en las últimas 24 horas.']);
        }
    
        // Obtener los datos del request
        $json = $this->request->getJSON();
    
        // Crear los datos del ticket con la información de soporte
        $ticketData = [
            'FK_User' => $userId,
            'Category' => 'Soporte',  // Valor exacto en el ENUM
            'Priority' => 'Media',  // Valor permitido en ENUM
            'Reason' => 'Consulta o problema de soporte',  // Motivo general
            'Comments' => $json->supportReason,  // Guardar motivo en Comments
            'CreatedAt' => date('Y-m-d H:i:s'),
            'Status' => 'Pendiente'  // Valor predeterminado
        ];
    
        // Intentar insertar el ticket
        if ($ticketsModel->insert($ticketData)) {
            return $this->response->setJSON(['success' => true, 'message' => 'Ticket de soporte creado exitosamente']);
        } else {
            // Obtener el error generado por el modelo
            $errors = $ticketsModel->errors();
            return $this->response->setJSON(['success' => false, 'message' => 'Error al crear el ticket', 'errors' => $errors]);
        }
    }
    
    public function checkSupportRequest()
    {
        // Verificar si el usuario está loggeado
        if (!session()->get('is_logged')) {
            return $this->response->setJSON(['hasPendingRequest' => false, 'message' => 'Usuario no loggeado']);
        }
    
        // Obtener el userId desde la sesión
        $userId = session()->get('PK_User');
    
        // Verificar si ya existe un ticket de soporte enviado en las últimas 24 horas
        $ticketsModel = new TicketsModel();
        $oneDayAgo = date('Y-m-d H:i:s', strtotime('-1 day'));
    
        $existingTicket = $ticketsModel
            ->where('FK_User', $userId)
            ->where('Category', 'Soporte')
            ->where('CreatedAt >=', $oneDayAgo)
            ->first();
    
        if ($existingTicket) {
            return $this->response->setJSON(['hasPendingRequest' => true, 'message' => 'Ya tienes una solicitud de soporte en las últimas 24 horas.']);
        } else {
            return $this->response->setJSON(['hasPendingRequest' => false]);
        }
    }
    



}
