<?php

namespace App\Controllers\TestController;

use App\Models\TestModel;
use App\Models\TestViewModel;
use App\Models\GroupModel;
use CodeIgniter\Controller;


class TestController extends Controller
{
    public function index()
    {
        if (!session()->get('is_logged')) {
            return redirect()->to('/login');
        }
    
        // Obtener el rol del usuario desde la sesión
        $role = session()->get('FK_Rol');
        $groupId = session()->get('FK_Group');
    
        log_message('debug', 'Rol del usuario: ' . $role . ' | Grupo: ' . $groupId);  // Mensaje de depuración
    
        $testViewModel = new TestViewModel();
        $groupModel = new GroupModel();
    
        // Si el rol es 2 o 3, obtener todos los exámenes sin filtrar por grupo
        if (in_array($role, [2, 3])) {
            $data['assignedTests'] = $testViewModel->getAllTests();  // Obtener todos los exámenes sin filtro
        } else {
            // Verificar si el usuario tiene asignado un grupo para roles diferentes a 2 y 3
            if (empty($groupId)) {
                return redirect()->back()->with('error', 'No se encontró un grupo asignado para este usuario.');
            }
    
            // Obtener solo los exámenes asignados para el grupo del usuario logueado
            $data['assignedTests'] = $testViewModel->getAssignedTestsForGroup($groupId);
        }
    
        // Obtener los grupos activos (esto lo puedes ajustar según sea necesario)
        $data['group'] = $groupModel->getActiveGroups();
    
        return view('test/test', $data);
    }
    
    
    public function createTest(){
        $testModel = new TestModel();
    
        $name = $this->request->getPost('Name');
        $description = $this->request->getPost('Description');
        $duration = $this->request->getPost('Duration');

        if (empty($name) || empty($description) || empty($duration)) {
            return redirect()->back()->with('error', 'Por favor, completa todos los campos.');
        }

        $data = [
            'NameTest' => $name,
            'Description' => $description, 
            'DurationTime' => $duration
        ];
        $testModel->save($data);
    
        return redirect()->to('/test')->with('success', 'Examen creado exitosamente.');
        }

        public function updateTestStatus() {
            $testModel = new TestModel();
        
            $id = $this->request->getPost('testId');
        
            $currentTest = $testModel->find($id);
        
            if (!$currentTest) {
                return redirect()->back()->with('error', 'Test no encontrado');
            }
        
            $statusList = ['Sin-asignar', 'Asignado', 'Terminado'];
        
            $currentStatus = $currentTest['Status'];
            $currentIndex = array_search($currentStatus, $statusList);
            $nextStatus = $statusList[($currentIndex + 1) % count($statusList)];
        
            $data = [
                'PK_Test' => $id,
                'Status' => $nextStatus
            ];
            if ($testModel->update($id, $data)) {
                return redirect()->back()->with('success', 'Status actualizado al siguiente valor: ' . $nextStatus);
            } else {
                return redirect()->back()->with('error', 'Error al actualizar el status');
            }
        }

        public function AssignGroup(){
            $testModel = new TestModel();

            $id = $this->request->getPost('Id');
            $groupId = $this->request->getPost('groupId');

            if (empty($id) || empty($groupId) ) {
                return redirect()->back()->with('error', 'Por favor, completa todos los campos.');
            }

            $data = [
                'PK_Test' => $id,
                'FK_Group' => $groupId
            ];
            if ($testModel->update($id, $data)) {
                return redirect()->back()->with('success', 'Grupo asignado correctamente');
            } else {
                return redirect()->back()->with('error', 'Error al asignar el grupo');
            }
        }

        // Función para obtener la información del test por su PK
            public function getTestInfo($pk)
            {
                $testVieModel = new TestViewModel();
                $info = $testVieModel->getTestInfoByPk($pk);
                echo json_encode($info);
            }
            public function startTest()
            {
                $testId = $this->request->getPost('testId');
                $userId = $this->request->getPost('userId');
                $nameTest = $this->request->getPost('nameTest');
                $description = $this->request->getPost('description');
                $durationTime = $this->request->getPost('durationTime');
                $groupId = $this->request->getPost('groupId');
            
                // Verificar que se han recibido los valores necesarios
                if (empty($testId) || empty($userId)) {
                    return redirect()->back()->with('error', 'Datos insuficientes para iniciar el examen.');
                }
            
                // Agrega un mensaje de depuración
                log_message('debug', 'Valores recibidos: TestID: ' . $testId . ', UserID: ' . $userId . ', NameTest: ' . $nameTest . ', Description: ' . $description . ', DurationTime: ' . $durationTime . ', GroupID: ' . $groupId);
            
                // Obtener el modelo de la tabla t_test_students
                $testStudentModel = new \App\Models\TestStudentModel();
            
                // Verificar si ya existe un registro para este test y usuario
                $existingRecord = $testStudentModel->where('FK_Test', $testId)
                                                ->where('FK_User', $userId)
                                                ->first();
            
                // Si no existe, crear un nuevo registro
                if (!$existingRecord) {
                    $data = [
                        'FK_Test' => $testId,
                        'FK_User' => $userId,
                        'NameTest' => $nameTest,
                        'Description' => $description,
                        'DurationTime' => $durationTime,
                        'FK_Group' => $groupId,
                        'Status' => 'Sin-Empezar', // Estado inicial
                        'CreatedAt' => date('Y-m-d H:i:s'),
                        'StartedAt' => null, // Se actualizará cuando el examen comience
                        'FinishedAt' => null
                    ];
            
                    // Insertar el nuevo registro
                    if (!$testStudentModel->insert($data)) {
                        return redirect()->back()->with('error', 'Error al iniciar el examen.');
                    }
                } else {
                    // Si ya existe un registro, actualizar el estado a 'Comenzado'
                    $testStudentModel->where('FK_Test', $testId)
                                     ->where('FK_User', $userId)
                                     ->set('Status', 'Comenzado')
                                     ->set('StartedAt', date('Y-m-d H:i:s'))
                                     ->update();
                }
            
                // Redirigir a la vista de examen
                return redirect()->to('exam/startTest')->with('success', 'El examen ha comenzado.');
            }
            
            
}