<?php
namespace App\Controllers\TestController;

use App\Models\TestStudentModel;
use App\Models\TestModel;
use App\Models\QuestionGrammarModel; 
use App\Models\AnswersTypeGrammarModel;
use App\Models\QuestionTypeTextModel;
use App\Models\TimelineQuestionTypeModel;
use App\Models\TimelineEventsModel;
use App\Models\QuestionsCategories\QuestionMathModel; 
use App\Models\QuestionsCategories\ViewQuestionsCategoriesModel; 
use CodeIgniter\Controller;
use App\Models\TimelineNEventsModel;

class TestStart extends Controller
{
    public function startTest()
    {
        // Verificar si el usuario está logueado
        if (!session()->get('is_logged')) {
            return redirect()->to('/login');
        }
    
        // Obtener el ID del test y del usuario desde POST y la sesión
        $testId = $this->request->getPost('testId');
        $userId = session()->get('PK_User'); // Obtener el PK_User de la sesión
    
        if (empty($testId) || empty($userId)) {
            return redirect()->back()->with('error', 'No se ha proporcionado el ID del examen o el ID del usuario.');
        }
    
        // Obtener información del examen desde t_test
        $testModel = new TestModel();
        $testInfo = $testModel->find($testId);
    
        if (!$testInfo) {
            return redirect()->back()->with('error', 'No se encontró el examen.');
        }
    
        // Verificar si el examen está asignado al usuario en t_test_students
        $testStudentModel = new TestStudentModel();
        $testStudentInfo = $testStudentModel->where('FK_Test', $testId)
                                            ->where('FK_User', $userId)
                                            ->first();
    
        // Si no se encuentra información, insertar el registro en t_test_students
        if (!$testStudentInfo) {
            $data = [
                'FK_Test' => $testId,
                'FK_User' => $userId,
                'Status' => 'Comenzado',
                'NameTest' => $testInfo['NameTest'],
                'CreatedAt' => date('Y-m-d H:i:s'),
                'Description' => $testInfo['Description'],
                'DurationTime' => $testInfo['DurationTime'],
                'FK_Group' => $testInfo['FK_Group'],
                'StartedAt' => date('Y-m-d H:i:s'),
            ];
    
            // Insertar el nuevo registro
            $testStudentModel->insert($data);
    
            // Volver a obtener el registro recién insertado
            $testStudentInfo = $testStudentModel->where('FK_Test', $testId)
                                                ->where('FK_User', $userId)
                                                ->first();
        } else {
            // Actualizar el estado a 'Comenzado' si no está ya en ese estado
            if ($testStudentInfo['Status'] !== 'Comenzado') {
                $testStudentModel->where('FK_Test', $testId)
                                ->where('FK_User', $userId)
                                ->set('Status', 'Comenzado')
                                ->set('StartedAt', date('Y-m-d H:i:s'))
                                ->update();
            }
        }
    
        // Cargar las preguntas gramaticales, de texto, matemáticas y categorías asociadas al examen
        $grammarModel = new QuestionGrammarModel();
        $grammarQuestions = $grammarModel->where('FK_Test', $testId)->findAll();
    
        $typetextModel = new QuestionTypeTextModel();
        $typetextQuestions = $typetextModel->where('FK_Test', $testId)->findAll();
        $timelineModel = new TimelineNEventsModel();
        $timelineQuestions = $timelineModel->where('FK_Test', $testId)->findAll();
    
        $mathModel = new QuestionMathModel();
        $mathQuestions = $mathModel->getMathQuestionsByTest($testId);
    
        // **Cargar las preguntas de categorías asociadas al examen**
        $viewCategoriesModel = new ViewQuestionsCategoriesModel();
        $rawCategoryQuestions = $viewCategoriesModel->getQuestionsByTestId($testId);
    
        // Estructurar las preguntas de categorías
        $categoryQuestions = [];
        foreach ($rawCategoryQuestions as $item) {
            $questionId = $item['PK_Question'];
            $categoryId = $item['PK_Category'];

            // Asegurarse de que `PK_Question` esté incluido al nivel de la pregunta
            if (!isset($categoryQuestions[$questionId])) {
                $categoryQuestions[$questionId] = [
                    'PK_Question' => $questionId,  // Añadir `PK_Question` aquí
                    'Question' => $item['Question'],
                    'Instructions' => $item['Instructions'],
                    'Categories' => []
                ];
            }

            // Estructurar las categorías dentro de las preguntas
            if (!isset($categoryQuestions[$questionId]['Categories'][$categoryId])) {
                $categoryQuestions[$questionId]['Categories'][$categoryId] = [
                    'Category' => $item['Category'],
                    'Items' => []
                ];
            }

            // Añadir el ítem a la categoría
            if (!empty($item['Item'])) {
                $categoryQuestions[$questionId]['Categories'][$categoryId]['Items'][] = $item['Item'];
            }
        }

        // Convertir `$categoryQuestions` en un arreglo indexado (sin claves de pregunta)
        $categoryQuestions = array_values($categoryQuestions);

        // Verificar si se encontraron preguntas
        if (empty($grammarQuestions) && empty($typetextQuestions) && empty($mathQuestions) && empty($categoryQuestions)) {
            return redirect()->back()->with('error', 'No se encontraron preguntas para este examen.');
        }
    
        // Pasar los datos a la vista para renderizar el examen y las preguntas
        $data = [
            'testInfo' => $testInfo,
            'testStudentInfo' => $testStudentInfo,
            'grammarQuestions' => $grammarQuestions,  // Enviar las preguntas a la vista
            'timelineQuestions' => $timelineQuestions,
            'typetextQuestions' => $typetextQuestions,
            'mathQuestions' => $mathQuestions,
            'categoryQuestions' => $categoryQuestions // Pasamos las preguntas de categorías a la vista
        ];
    
        
        return view('test/startTest', $data);
    }
    

     // Función para procesar el envío de respuestas
    public function submitAnswers()
    {
        // Verificar si el usuario está logueado
        if (!session()->get('is_logged')) {
            return redirect()->to('/login');
        }

        // Obtener los datos del formulario
        $testId = $this->request->getPost('FK_Test');
        $userId = $this->request->getPost('PK_User');
        
        // Verificar que se haya recibido el ID del test y del usuario
        if (empty($testId) || empty($userId)) {
            return redirect()->back()->with('error', 'No se han proporcionado los datos necesarios.');
        }

        // Crear una instancia del modelo de respuestas
        $answersModel = new AnswersTypeGrammarModel();

        // Recorrer las respuestas enviadas por el usuario
        foreach ($this->request->getPost() as $key => $answer) {
            if (strpos($key, 'answer_') === 0) {
                // Extraer el FK_Question de la clave
                $questionId = str_replace('answer_', '', $key);

                // Almacenar la respuesta en la base de datos
                $data = [
                    'Answer' => $answer,
                    'FK_Test' => $testId,
                    'FK_User' => $userId,
                    'FK_Question' => $questionId,
                    'CreatedAt' => date('Y-m-d H:i:s')
                ];

                // Insertar la respuesta en la base de datos
                $answersModel->insert($data);
            }
        }

        // Redirigir después de guardar las respuestas
        return $this->response->setJSON(['success' => true, 'message' => 'Respuesta enviada correctamente.']);
    }

    public function submitAnswer()
    {
        // Verificar si el usuario está logueado
        if (!session()->get('is_logged')) {
            return $this->response->setJSON(['success' => false, 'error' => 'Usuario no autenticado.']);
        }
    
        // Obtener los datos enviados desde el formulario
        $testId = $this->request->getPost('FK_Test');
        $userId = $this->request->getPost('PK_User');
        $questionId = $this->request->getPost('FK_Question');
        $answer = $this->request->getPost('Answer');
    
        // Verificar que se hayan recibido los datos
        if (empty($testId) || empty($userId) || empty($questionId) || empty($answer)) {
            return $this->response->setJSON(['success' => false, 'error' => 'Datos incompletos']);
        }
    
        // Crear una instancia del modelo de respuestas
        $answersModel = new AnswersTypeGrammarModel();
    
        // Insertar la respuesta en la base de datos
        $data = [
            'FK_Test' => $testId,
            'FK_User' => $userId,
            'FK_Question' => $questionId,
            'Answer' => $answer,
            'CreatedAt' => date('Y-m-d H:i:s')
        ];
    
        if ($answersModel->insert($data)) {
            return $this->response->setJSON(['success' => true, 'message' => 'Respuesta enviada correctamente.']);
        } else {
            return $this->response->setJSON(['success' => false, 'error' => 'Error al guardar la respuesta.']);
        }
    }
    

}
