<?php
namespace App\Controllers\TestController;

use App\Models\TestStudentModel;
use App\Models\TestModel;
use App\Models\QuestionsCategories\ViewQuestionsCategoriesModel; 
use App\Models\AnswersTypeCategoriesModel; 
use CodeIgniter\Controller;

class TypeCategoriesController extends Controller
{
    public function submitAnswer()
    {
        if (!session()->get('is_logged')) {
            log_message('error', 'Usuario no autenticado');
            return $this->response->setJSON(['success' => false, 'error' => 'Usuario no autenticado.']);
        }
    
        $testId = $this->request->getPost('FK_Test');
        $userId = $this->request->getPost('PK_User');
        $questionId = $this->request->getPost('FK_Question');
    
    
        if (empty($testId) || empty($userId) || empty($questionId)) {
            log_message('error', 'Datos incompletos en la solicitud');
            return $this->response->setJSON(['success' => false, 'error' => 'Datos incompletos']);
        }
    
        $answersModel = new AnswersTypeCategoriesModel();
        $allSaved = true;
        $index = 0;
    
        while ($this->request->getPost("FK_Category_$index") && $this->request->getPost("FK_Item_$index")) {
            $categoryId = $this->request->getPost("FK_Category_$index");
            $itemId = $this->request->getPost("FK_Item_$index");
    
            // Verificar los valores que se van a guardar en la base de datos
            log_message('info', "Guardando respuesta: FK_Category_$index=$categoryId, FK_Item_$index=$itemId");
    
            $data = [
                'FK_Test' => $testId,
                'FK_User' => $userId,
                'FK_Question' => $questionId,
                'FK_Category' => $categoryId,
                'FK_Item' => $itemId,
                'CreatedAt' => date('Y-m-d H:i:s')
            ];
    
            if (!$answersModel->insert($data)) {
                $allSaved = false;
                log_message('error', 'Error al insertar la respuesta para el ítem');
            }
            $index++;
        }
    
        if ($allSaved) {
            log_message('info', 'Respuestas insertadas correctamente');
            return $this->response->setJSON(['success' => true, 'message' => 'Respuestas enviadas correctamente.']);
        } else {
            return $this->response->setJSON(['success' => false, 'error' => 'Error al guardar una o más respuestas.']);
        }
    }
    

}
