<?php
namespace App\Controllers\TestController;

use App\Models\TestStudentModel;
use App\Models\TestModel;
use App\Models\QuestionsCategories\QuestionMathModel; 
use App\Models\AnswerTypeMathModel;
use CodeIgniter\Controller;

class TypeMathController extends Controller
{
    public function submitAnswer()
    {
        // Verificar si el usuario está logueado
        if (!session()->get('is_logged')) {
            log_message('error', 'Usuario no autenticado');
            return $this->response->setJSON(['success' => false, 'error' => 'Usuario no autenticado.']);
        }
    
        // Obtener los datos enviados desde el formulario
        $testId = $this->request->getPost('FK_Test');
        $userId = $this->request->getPost('PK_User');
        $questionId = $this->request->getPost('FK_Question');
        $answer = $this->request->getPost('Answer');
    
        // Registrar los datos recibidos
        log_message('info', 'Datos recibidos: FK_Test=' . $testId . ', PK_User=' . $userId . ', FK_Question=' . $questionId . ', Answer=' . $answer);
    
        // Verificar que se hayan recibido los datos
        if (empty($testId) || empty($userId) || empty($questionId) || empty($answer)) {
            log_message('error', 'Datos incompletos en la solicitud');
            return $this->response->setJSON(['success' => false, 'error' => 'Datos incompletos']);
        }
    
        // Crear una instancia del modelo de respuestas
        $answersMathModel = new AnswerTypeMathModel();
    
        // Insertar la respuesta en la base de datos
        $data = [
            'FK_Test' => $testId,
            'FK_User' => $userId,
            'FK_Question' => $questionId,
            'Answer' => $answer,
            'CreatedAt' => date('Y-m-d H:i:s')
        ];
    
        if ($answersMathModel->insert($data)) {
            log_message('info', 'Respuesta insertada correctamente');
            return $this->response->setJSON(['success' => true, 'message' => 'Respuesta enviada correctamente.']);
        } else {
            log_message('error', 'Error al insertar la respuesta');
            return $this->response->setJSON(['success' => false, 'error' => 'Error al guardar la respuesta.']);
        }
    }
    
}