<?php
namespace App\Controllers\TestController;

use App\Models\TestStudentModel;
use App\Models\TestModel;
use App\Models\QuestionTypeTextModel;
use App\Models\AnswerTypeTextModel;
use CodeIgniter\Controller;

class TypeTextController extends Controller
{
     // Función para procesar el envío de respuestas
        public function submitAnswers()
        {
            // Verificar si el usuario está logueado
            if (!session()->get('is_logged')) {
                return redirect()->to('/login');
            }
    
            // Obtener los datos del formulario
            $testId = $this->request->getPost('FK_Test');
            $userId = $this->request->getPost('PK_User');
            
            // Verificar que se haya recibido el ID del test y del usuario
            if (empty($testId) || empty($userId)) {
                return redirect()->back()->with('error', 'No se han proporcionado los datos necesarios.');
            }
    
            // Crear una instancia del modelo de respuestas
            $answersModel = new AnswerTypeTextModel();
    
            // Recorrer las respuestas enviadas por el usuario
            foreach ($this->request->getPost() as $key => $answer) {
                if (strpos($key, 'answer_') === 0) {
                    // Extraer el FK_Question de la clave
                    $questionId = str_replace('answer_', '', $key);
    
                    // Almacenar la respuesta en la base de datos
                    $data = [
                        'Answer' => $answer,
                        'FK_Test' => $testId,
                        'FK_User' => $userId,
                        'FK_Question' => $questionId,
                        'CreatedAt' => date('Y-m-d H:i:s')
                    ];
    
                    // Insertar la respuesta en la base de datos
                    $answersModel->insert($data);
                }
            }
    
            // Redirigir después de guardar las respuestas
            return redirect()->to('/test/result')->with('success', 'Tus respuestas han sido enviadas exitosamente.');
        }
    
        public function submitAnswer()
        {
            // Verificar si el usuario está logueado
            if (!session()->get('is_logged')) {
                return $this->response->setJSON(['success' => false, 'error' => 'Usuario no autenticado.']);
            }
        
            // Obtener los datos enviados desde el formulario
            $testId = $this->request->getPost('FK_Test');
            $userId = $this->request->getPost('PK_User');
            $questionId = $this->request->getPost('FK_Question');
            $answer = $this->request->getPost('Answer');
        
            // Verificar que se hayan recibido los datos
            if (empty($testId) || empty($userId) || empty($questionId) || empty($answer)) {
                return $this->response->setJSON(['success' => false, 'error' => 'Datos incompletos']);
            }
        
            // Crear una instancia del modelo de respuestas
            $answersModel = new AnswerTypeTextModel();
        
            // Insertar la respuesta en la base de datos
            $data = [
                'FK_Test' => $testId,
                'FK_User' => $userId,
                'FK_Question' => $questionId,
                'Answer' => $answer,
                'CreatedAt' => date('Y-m-d H:i:s')
            ];
        
            if ($answersModel->insert($data)) {
                return $this->response->setJSON(['success' => true, 'message' => 'Respuesta enviada correctamente.']);
            } else {
                return $this->response->setJSON(['success' => false, 'error' => 'Error al guardar la respuesta.']);
            }
        }
     
}