<?php

namespace App\Controllers\Tickets;

use CodeIgniter\Controller;
use App\Models\TicketsViewModel; 
use App\Models\TicketsModel; 
use App\Models\UserModel;
use App\Entities\User; 
class Tickets extends Controller
{
    protected $ticketsViewModel;
    protected $ticketsModel;

    public function __construct()
    {
        // Inicializar ambos modelos
        $this->ticketsViewModel = new TicketsViewModel();
        $this->ticketsModel = new TicketsModel();  // Inicializamos también TicketsModel para los updates
    }

    public function index()
    {
        // Verificar si el usuario está logueado
        if (!session()->get('is_logged')) {
            return redirect()->to('/login');  // Redirigir al login si no está logueado
        }

        // Obtener todos los tickets desde la vista
        $tickets = $this->ticketsViewModel
            ->orderBy('CreatedAt', 'DESC')
            ->findAll();

        // Cargar la vista de tickets con todos los datos de la vista
        return view('settings/tickets', ['tickets' => $tickets]);
    }

    // Función para obtener tickets por categoría
    public function getTicketsByCategory($category)
    {
        $tickets = $this->ticketsViewModel
            ->where('Category', $category)
            ->orderBy('CreatedAt', 'DESC')
            ->findAll();

        return view('settings/tickets', ['tickets' => $tickets]);
    }

    // Función para resolver un ticket
    public function resolveTicket()
    {
        // Verificar si el usuario está logueado
        if (!session()->get('is_logged')) {
            return redirect()->to('/login');  // Redirigir al login si no está logueado
        }

        // Obtener el ID del ticket desde el request
        $ticketId = $this->request->getJSON()->resolveTicketId;

        // Verificar si se recibió un ID válido
        if (!$ticketId) {
            return $this->response->setJSON(['success' => false, 'message' => 'No se recibió un ID de ticket válido']);
        }

        // Usar el modelo `TicketsModel` para marcar el ticket como resuelto
        $success = $this->ticketsModel->resolveTicket($ticketId);

        if ($success) {
            return $this->response->setJSON(['success' => true, 'message' => 'Ticket marcado como resuelto']);
        } else {
            return $this->response->setJSON(['success' => false, 'message' => 'Hubo un problema al marcar el ticket como resuelto']);
        }
    }

    public function changePassword()
    {
        // Obtener los datos de la solicitud JSON
        $requestData = $this->request->getJSON();
    
        // Verificar si se recibió el ticketId y la nueva contraseña
        if (!isset($requestData->ticketId) || !isset($requestData->newPassword)) {
            return $this->response->setJSON(['success' => false, 'message' => 'Datos inválidos']);
        }
    
        $ticketId = $requestData->ticketId;
        $newPassword = $requestData->newPassword;
    
        // Obtener el ticket para encontrar el FK_User asociado
        $ticketsModel = new TicketsModel();
        $ticket = $ticketsModel->find($ticketId);
    
        if (!$ticket) {
            return $this->response->setJSON(['success' => false, 'message' => 'Ticket no encontrado']);
        }
    
        $fkUser = $ticket['FK_User'];
    
        // Obtener al usuario por FK_User y cambiar la contraseña
        $userModel = new UserModel();
        $user = $userModel->find($fkUser);
    
        if ($user) {
            // Establecer la nueva contraseña (se encriptará automáticamente por la entidad User)
            $user->Password = $newPassword;
            if ($userModel->save($user)) {
                return $this->response->setJSON(['success' => true, 'message' => 'Contraseña cambiada exitosamente']);
            } else {
                return $this->response->setJSON(['success' => false, 'message' => 'Error al cambiar la contraseña']);
            }
        } else {
            return $this->response->setJSON(['success' => false, 'message' => 'Usuario no encontrado']);
        }
    }
    
}
