<?php

namespace App\Models;

use CodeIgniter\Model;

class AnswersTypeGrammarModel extends Model
{
    protected $table = 't_answers_type_grammar'; // Nombre de la tabla
    protected $primaryKey = 'PK_Answer_Student'; // Clave primaria

    protected $allowedFields = [
        'Answer',
        'FK_Test',
        'FK_User',
        'FK_Question',
        'CreatedAt'
    ];

    // Activar timestamps automáticos
    protected $useTimestamps = false;
    protected $createdField = 'CreatedAt';

    // Reglas de validación
    protected $validationRules = [
        'Answer' => 'required|string|max_length[255]',
        'FK_Test' => 'required|integer',
        'FK_User' => 'required|integer',
        'FK_Question' => 'required|integer'
    ];

    // Mensajes de validación personalizados
    protected $validationMessages = [
        'Answer' => [
            'required' => 'La respuesta es obligatoria.',
            'max_length' => 'La respuesta no debe exceder los 255 caracteres.'
        ],
        'FK_Test' => [
            'required' => 'El ID del examen es obligatorio.',
            'integer' => 'El ID del examen debe ser un número entero.'
        ],
        'FK_User' => [
            'required' => 'El ID del usuario es obligatorio.',
            'integer' => 'El ID del usuario debe ser un número entero.'
        ],
        'FK_Question' => [
            'required' => 'El ID de la pregunta es obligatorio.',
            'integer' => 'El ID de la pregunta debe ser un número entero.'
        ]
    ];
}
