<?php 
namespace App\Models;

use CodeIgniter\Model;

class GroupModel extends Model
{
    protected $table      = 't_group';
    protected $primaryKey = 'PK_Group';

    protected $allowedFields = [
        'PK_Group',
        'GroupName',
        'Description',
        'CreatedAt',
        'UpdatedAt',
        'Status'
    ];

    // Función para obtener todos los grupos activos (Status = 1)
    public function getActiveGroups()
    {
        $result = $this->where('Status', 1)->findAll();
        return $result;
    }
    
    public function getRecentActiveGroups()
    {
        return $this->asArray() 
                    ->where('Status', 1)
                    ->orderBy('CreatedAt', 'DESC') 
                    ->findAll();
    }
    
}
