<?php

namespace App\Models;

use CodeIgniter\Model;

class MaterialModel extends Model
{
    // Nombre de la tabla
    protected $table = 't_material';

    // Clave primaria
    protected $primaryKey = 'PK_Material';

    // Campos permitidos para inserción y actualización
    protected $allowedFields = [
        'Name',
        'Link',
        'FK_Group',
        'CreatedAt',
        'UpdatedAt',
        'Status'
    ];

    // Activar timestamps automáticos para las columnas CreatedAt y UpdatedAt
    protected $useTimestamps = true;
    protected $createdField = 'CreatedAt';
    protected $updatedField = 'UpdatedAt';

    // Validación de los campos
    protected $validationRules = [
        'Name' => 'required|string|max_length[255]',
        'Link' => 'required|valid_url',
        'FK_Group' => 'required|integer',
        'Status' => 'in_list[1,0]',  // 1 = Activo, 0 = Inactivo
    ];

    // Mensajes personalizados de error (opcional)
    protected $validationMessages = [
        'Name' => [
            'required' => 'El nombre es obligatorio',
            'max_length' => 'El nombre no puede exceder los 255 caracteres'
        ],
        'Link' => [
            'required' => 'El enlace es obligatorio',
            'valid_url' => 'Debe proporcionar una URL válida'
        ],
        'FK_Group' => [
            'required' => 'El grupo es obligatorio',
            'integer' => 'El valor de grupo debe ser un número entero'
        ]
    ];

    // Métodos personalizados
    public function getActiveMaterials()
    {
        return $this->where('Status', 1)->findAll();
    }

    public function getMaterialsByGroup($groupId)
    {
        return $this->where('FK_Group', $groupId)->findAll();
    }
}
