<?php

namespace App\Models;

use CodeIgniter\Model;

class MaterialUsersModel extends Model
{
    protected $table = 'v_material_allusers';
    
    protected $primaryKey = 'PK_Material';
    
    protected $useTimestamps = false;

    protected $allowedFields = [
        'PK_Material',
        'Name',
        'Link',
        'GroupName',
        'CreatedAt',
        'UpdatedAt',
        'Status'
    ];

    // Método para obtener todos los materiales
    public function getAllMaterials()
    {
        return $this->findAll();
    }

    // Método para obtener materiales por grupo
    public function getMaterialsByGroup($groupId)
    {
        return $this->where('FK_Group', $groupId)->findAll();
    }

    // Método para obtener materiales activos
    public function getActiveMaterials()
    {
        return $this->where('Status', 1)->findAll();
    }
}
