<?php

namespace App\Models;

use CodeIgniter\Model;

class QuestionGrammarModel extends Model
{
    protected $table = 't_question_grammar'; 
    protected $primaryKey = 'PK_Question';    

    protected $allowedFields = [
        'Question',
        'CorrectAnswer',
        'Option1',
        'Option2',
        'Option3',
        'Option4',
        'Instructions',
        'Subject',
        'CreatedAt',
        'UpdatedAt',
        'FK_Test',
        'TypeQuestion'
    ];

    // Campos de timestamps automáticos
    protected $useTimestamps = true;
    protected $createdField = 'CreatedAt';
    protected $updatedField = 'UpdatedAt';

    // Reglas de validación
    protected $validationRules = [
        'Question' => 'required|string|max_length[255]',
        'CorrectAnswer' => 'required|string|max_length[255]',
        'Option1' => 'required|string|max_length[255]',
        'Option2' => 'required|string|max_length[255]',
        'Option3' => 'required|string|max_length[255]',
        'Option4' => 'required|string|max_length[255]',
        'Instructions' => 'required|string',
        'Subject' => 'required|string|max_length[255]',
        'FK_Test' => 'required|integer',
    ];

    // Mensajes personalizados de validación
    protected $validationMessages = [
        'Question' => [
            'required' => 'La pregunta es obligatoria.',
            'max_length' => 'La pregunta no debe exceder los 255 caracteres.'
        ],
        'CorrectAnswer' => [
            'required' => 'La respuesta correcta es obligatoria.',
            'max_length' => 'La respuesta correcta no debe exceder los 255 caracteres.'
        ],
        'Option1' => [
            'required' => 'La primera opción es obligatoria.',
            'max_length' => 'La primera opción no debe exceder los 255 caracteres.'
        ],
        'Option2' => [
            'required' => 'La segunda opción es obligatoria.',
            'max_length' => 'La segunda opción no debe exceder los 255 caracteres.'
        ],
        'Option3' => [
            'required' => 'La tercera opción es obligatoria.',
            'max_length' => 'La tercera opción no debe exceder los 255 caracteres.'
        ],
        'Option4' => [
            'required' => 'La cuarta opción es obligatoria.',
            'max_length' => 'La cuarta opción no debe exceder los 255 caracteres.'
        ],
        'Instructions' => [
            'required' => 'Las instrucciones son obligatorias.'
        ],
        'Subject' => [
            'required' => 'La materia es obligatoria.',
            'max_length' => 'La materia no debe exceder los 255 caracteres.'
        ],
        'FK_Test' => [
            'required' => 'El ID del examen es obligatorio.',
            'integer' => 'El ID del examen debe ser un número entero.'
        ]
    ];
}

