<?php

namespace App\Models;

use CodeIgniter\Model;

class QuestionTypeTextModel extends Model
{
    protected $table = 't_question_type_text'; 
    protected $primaryKey = 'PK_Question';     

    protected $allowedFields = [
        'Question',
        'CorrectAnswer', 
        'Subject',
        'CreatedAt',
        'UpdatedAt',
        'FK_Test', 
        'UploadMaterial',
        'TypeQuestion',
        'Instructions'
    ];
    
    protected $useTimestamps = true;
    protected $createdField = 'CreatedAt';
    protected $updatedField = 'UpdatedAt';

    // Validaciones opcionales
    protected $validationRules = [
        'Question' => 'required|string|max_length[255]',
        'CorrectAnswer' => 'required|string', 
        'Instructions' => 'required|string|max_length[255]', 
        'Subject' => 'required|string|max_length[255]',
        'FK_Test' => 'required|integer'
    ];
    
    // Mensajes de error personalizados
    protected $validationMessages = [
        'Question' => [
            'required' => 'La pregunta es obligatoria',
            'max_length' => 'La pregunta no debe exceder los 255 caracteres'
        ],
        'NumAnswers' => [
            'required' => 'El número de respuestas es obligatorio',
            'integer' => 'El campo debe ser un número entero'
        ],
        'Instructions' => [
            'required' => 'El campo de instrucciones es obligatorio',
            'max_length' => 'La materia no debe exceder los 255 caracteres'
        ],
        'Subject' => [
            'required' => 'La materia es obligatoria',
            'max_length' => 'La materia no debe exceder los 255 caracteres'
        ],
        'FK_Test' => [
            'required' => 'El ID del examen es obligatorio',
            'integer' => 'El ID del examen debe ser un número entero'
        ]
    ];
}
