<?php

namespace App\Models\QuestionsCategories;

use CodeIgniter\Model;

class CategoryItemsModel extends Model
{
    protected $table = 't_category_items';
    protected $primaryKey = 'PK_Item';

    // Campos permitidos para inserción y actualización
    protected $allowedFields = [
        'FK_Category',
        'Item',
        'CreatedAt'
    ];

    /**
     * Función para obtener todos los items de una categoría específica
     *
     * @param int $categoryId ID de la categoría
     * @return array Resultados de los elementos en la categoría
     */
    public function getItemsByCategory($categoryId)
    {
        return $this->where('FK_Category', $categoryId)->findAll();
    }
}
