<?php

namespace App\Models\QuestionsCategories;

use CodeIgniter\Model;

class QuestionCategoriesModel extends Model
{
    protected $table = 't_question_categories';
    protected $primaryKey = 'PK_Category';

    // Campos permitidos para inserción/actualización
    protected $allowedFields = [
        'FK_Question',
        'Category',
        'FK_Test'
    ];

    // Reglas de validación
    protected $validationRules = [
        'FK_Question' => 'required|integer',
        'Category' => 'required|string|max_length[255]'
    ];

    // Mensajes personalizados de validación
    protected $validationMessages = [
        'FK_Question' => [
            'required' => 'El ID de la pregunta es obligatorio.',
            'integer' => 'El ID de la pregunta debe ser un número entero.'
        ],
        'Category' => [
            'required' => 'La categoría es obligatoria.',
            'max_length' => 'La categoría no debe exceder los 255 caracteres.'
        ]
    ];
}
