<?php

namespace App\Models\QuestionsCategories;

use CodeIgniter\Model;

class QuestionMathModel extends Model
{
    protected $table = 't_questions_math';
    protected $primaryKey = 'PK_Question';

    protected $allowedFields = [
        'Question',
        'Instructions',
        'CorrectAnswer',
        'Option1',
        'Option2',
        'Option3',
        'Option4',
        'Subject',
        'CreatedAt',
        'UpdatedAt',
        'FK_Test',
        'TypeQuestion',
        'UploadMaterial'
    ];

    public function getMathQuestionsByTest($testId)
    {
        return $this->where('FK_Test', $testId)->findAll();
    }
    
}
