<?php
namespace App\Models\QuestionsCategories;

use CodeIgniter\Model;

class QuestionOptionsModel extends Model
{
    protected $table = 't_question_options';
    protected $primaryKey = 'PK_Option';

    // Campos permitidos para inserción/actualización
    protected $allowedFields = [
        'FK_Question',
        'OptionText',
        'IsCorrect',
        'FK_Test'
    ];

    // Reglas de validación
    protected $validationRules = [
        'FK_Question' => 'required|integer',
        'OptionText' => 'required|string|max_length[255]',
        'IsCorrect' => 'required|in_list[0,1]'  // Modificado para aceptar 0 o 1
    ];

    // Mensajes personalizados de validación
    protected $validationMessages = [
        'FK_Question' => [
            'required' => 'El ID de la pregunta es obligatorio.',
            'integer' => 'El ID de la pregunta debe ser un número entero.'
        ],
        'OptionText' => [
            'required' => 'La opción es obligatoria.',
            'max_length' => 'La opción no debe exceder los 255 caracteres.'
        ],
        'IsCorrect' => [
            'required' => 'Especificar si la opción es correcta es obligatorio.',
            'in_list' => 'El valor debe ser 0 (incorrecto) o 1 (correcto).'
        ]
    ];
}
