<?php

namespace App\Models\QuestionsCategories;

use CodeIgniter\Model;

class QuestionsTypeCategoriesModel extends Model
{
    protected $table = 't_questions_type_categories';
    protected $primaryKey = 'PK_Question';

    // Campos permitidos para inserción/actualización
    protected $allowedFields = [
        'Question',
        'Instructions',
        'CreatedAt',
        'UpdatedAt',
        'FK_Test',
        'TypeQuestion'
    ];

    // Campos de timestamps automáticos
    protected $useTimestamps = true;
    protected $createdField = 'CreatedAt';
    protected $updatedField = 'UpdatedAt';

    // Reglas de validación
    protected $validationRules = [
        'Question' => 'required|string|max_length[255]',
        'Instructions' => 'required|string',
        'FK_Test' => 'required|integer',
        'TypeQuestion' => 'required|string|max_length[100]'
    ];

    // Mensajes personalizados de validación
    protected $validationMessages = [
        'Question' => [
            'required' => 'La pregunta es obligatoria.',
            'max_length' => 'La pregunta no debe exceder los 255 caracteres.'
        ],
        'Instructions' => [
            'required' => 'Las instrucciones son obligatorias.'
        ],
        'FK_Test' => [
            'required' => 'El ID del examen es obligatorio.',
            'integer' => 'El ID del examen debe ser un número entero.'
        ],
        'TypeQuestion' => [
            'required' => 'El tipo de pregunta es obligatorio.',
            'max_length' => 'El tipo de pregunta no debe exceder los 100 caracteres.'
        ]
    ];
}
