<?php

namespace App\Models\QuestionsCategories;

use CodeIgniter\Model;

class ViewQuestionsCategoriesModel extends Model
{
    protected $table = 'v_questions_type_categories';
    protected $primaryKey = 'PK_Question';

    protected $allowedFields = [
        'PK_Question',
        'Question',
        'Instructions',
        'QuestionCreatedAt',
        'QuestionUpdatedAt',
        'FK_Test',
        'TypeQuestion',
        'PK_Category',
        'Category',
        'CategoryCreatedAt',
        'PK_Item',
        'Item',
        'ItemCreatedAt'
    ];

    public function getQuestionsByTestId($testId)
    {
        return $this->where('FK_Test', $testId)->findAll();
    }

    protected $useAutoIncrement = false;
    protected $returnType = 'array';
    protected $useTimestamps = false;
}
