<?php

namespace App\Models;

use CodeIgniter\Model;

class QuestionsMathModel extends Model
{
    protected $table = 't_questions_math'; 
    protected $primaryKey = 'PK_Question';

    // Campos permitidos para inserción/actualización
    protected $allowedFields = [
        'Question',
        'Instructions',
        'CorrectAnswer',
        'Option1',
        'Option2',
        'Option3',
        'Option4',
        'Subject',
        'CreatedAt',
        'UpdatedAt',
        'FK_Test',
        'TypeQuestion',
        'UploadMaterial'  // Nuevo campo
    ];

    // Campos de timestamps automáticos
    protected $useTtimestamps = true;
    protected $createdField = 'CreatedAt';
    protected $updatedField = 'UpdatedAt';

    // Reglas de validación
    protected $validationRules = [
        'Question' => 'required|string|max_length[255]',
        'Instructions' => 'required|string',
        'CorrectAnswer' => 'required|string|max_length[255]',
        'Option1' => 'required|string|max_length[255]', // No permite NULL
        'Option2' => 'permit_empty|string|max_length[255]', // Permite NULL
        'Option3' => 'permit_empty|string|max_length[255]', // Permite NULL
        'Option4' => 'permit_empty|string|max_length[255]', // Permite NULL
        'Subject' => 'required|string|max_length[255]',
        'FK_Test' => 'required|integer',
        'UploadMaterial' => 'permit_empty|string|max_length[255]'  // Nuevo campo
    ];

    // Mensajes personalizados de validación
    protected $validationMessages = [
        'Question' => [
            'required' => 'La pregunta es obligatoria.',
            'max_length' => 'La pregunta no debe exceder los 255 caracteres.'
        ],
        'Instructions' => [
            'required' => 'Las instrucciones son obligatorias.'
        ],
        'CorrectAnswer' => [
            'required' => 'La respuesta correcta es obligatoria.',
            'max_length' => 'La respuesta correcta no debe exceder los 255 caracteres.'
        ],
        'Option1' => [
            'required' => 'La opción 1 es obligatoria.',
            'max_length' => 'La opción 1 no debe exceder los 255 caracteres.'
        ],
        'Option2' => [
            'permit_empty' => 'La opción 2 es opcional.',
            'max_length' => 'La opción 2 no debe exceder los 255 caracteres.'
        ],
        'Option3' => [
            'permit_empty' => 'La opción 3 es opcional.',
            'max_length' => 'La opción 3 no debe exceder los 255 caracteres.'
        ],
        'Option4' => [
            'permit_empty' => 'La opción 4 es opcional.',
            'max_length' => 'La opción 4 no debe exceder los 255 caracteres.'
        ],
        'Subject' => [
            'required' => 'La materia es obligatoria.',
            'max_length' => 'La materia no debe exceder los 255 caracteres.'
        ],
        'FK_Test' => [
            'required' => 'El ID del examen es obligatorio.',
            'integer' => 'El ID del examen debe ser un número entero.'
        ]
    ];
}
