<?php
namespace App\Models;

use CodeIgniter\Model;

class RecordedclassesModel extends Model
{
    protected $table      = 't_recorded_classes';  
    protected $primaryKey = 'PK_RecordedClass';  

    protected $allowedFields = [
        'ClassName', 
        'Link', 
        'FK_Group', 
        'RecordedAt', 
        'CreatedAt', 
        'UpdatedAt', 
        'Status'
    ];

    // Función para obtener todas las clases grabadas con Status = 1
    public function getActiveClasses()
    {
        return $this->where('Status', 1)
                    ->orderBy('RecordedAt', 'DESC')
                    ->findAll();
    }
    

    public function getActiveClassesForGroup($groupId)
{
    return $this->where('Status', 1)
                ->where('FK_Group', $groupId)
                ->orderBy('RecordedAt', 'DESC')
                ->findAll();
}


    // Función para eliminar lógicamente una clase (cambiando el status a 0)
    public function softDeleteClass($id)
    {
        return $this->update($id, ['Status' => 0]);
    }
}
