<?php 
namespace App\Models;

use CodeIgniter\Model;

class TestViewModel extends Model
{
    protected $table      = 'v_test';
    protected $primaryKey = 'PK_Test';

    protected $allowedFields = [
        'PK_Test',
        'NameTest',
        'CreatedAt',
        'Status',
        'StatusQuestions',
        'FinishedAt',
        'UpdatedAt',
        'Description',
        'DurationTime',
        'FK_Group',
        'GroupName'
    ];

    public function getTests(){
        return $this->findAll();
    }

        // Obtener todos los exámenes (para roles 2 y 3)
    public function getAllTests()
    {
        return $this->findAll();  // Devuelve todos los registros sin filtro
    }

    public function getTestInfoByPk($pk){
        return $this->where('PK_Test', $pk)->first();
    }
    // Nueva función para obtener exámenes asignados a un grupo específico
    public function getAssignedTestsForGroup($groupId)
    {
        return $this->where('FK_Group', $groupId)
                    ->where('Status', 'Asignado')
                    ->where('StatusQuestions', 'Asignada/as')
                    ->findAll();
    }

    public function getTestsWithQuestions()
{
    return $this->select('PK_Test, NameTest, Status, StatusQuestions')
                ->where('StatusQuestions !=', 'Sin-Asignar') // Filtro opcional si solo quieres ver exámenes asignados con preguntas
                ->findAll();
}


}