<?php

namespace App\Models;

use CodeIgniter\Model;

class TicketsViewModel extends Model
{
    // Nombre de la vista
    protected $table = 'v_all_tickets_from_user';

    // No hay clave primaria definida en la vista, pero si la hubiera
    protected $primaryKey = 'PK_Ticket';

    // Campos que se pueden obtener de la vista (no se pueden insertar o actualizar en una vista)
    protected $allowedFields = [
        'PK_Ticket',
        'FK_User',
        'Matricula',
        'Reason',
        'Category',
        'Priority',
        'CreatedAt',
        'AttendedAt',
        'Status',
        'Comments'
    ];

    // Validaciones (opcional, ya que es solo lectura, pero útil si decides hacer validaciones)
    protected $validationRules = [
        'PK_Ticket'   => 'required|integer',
        'FK_User'     => 'required|integer',
        'Matricula'   => 'required|string',
        'Reason'      => 'required|string',
        'Category'    => 'required|in_list[NuevaContraseña, Problema técnico, Consulta-general, Soporte, Otro]',
        'Priority'    => 'in_list[Baja, Media, Alta]',
        'Status'      => 'in_list[Pendiente, En proceso, Resuelto, Cancelado]',
    ];

    // Mensajes personalizados de error (opcional)
    protected $validationMessages = [
        'Category' => [
            'required' => 'La categoría es obligatoria',
            'in_list'  => 'La categoría debe ser una de las siguientes: NuevaContraseña, Problema técnico, Consulta-general, Soporte, Otro'
        ],
        'Status' => [
            'in_list'  => 'El estado debe ser una de las siguientes opciones: Pendiente, En proceso, Resuelto, Cancelado'
        ]
    ];

    // Métodos personalizados para consultas (solo lectura)
    public function getAllTickets()
    {
        return $this->findAll(); // Retorna todos los registros de la vista
    }

    public function getPendingTickets()
    {
        return $this->where('Status', 'Pendiente')->findAll(); // Retorna solo los tickets con Status = Pendiente
    }

    public function getTicketsByCategory($category)
    {
        return $this->where('Category', $category)->findAll(); // Retorna los tickets según la categoría
    }

    public function getTicketsByPriority($priority)
    {
        return $this->where('Priority', $priority)->findAll(); // Retorna los tickets según la prioridad
    }
}
