<?php 
namespace App\Models;

use CodeIgniter\Model;
use App\Entities\User;
use App\Models\GroupModel;

class UserModel extends Model
{
    protected $returnType = User::class;
    protected $table      = 't_user';
    protected $primaryKey = 'PK_User';

    protected $allowedFields = [
        'PK_User',
        'Name',
        'LastName',
        'Matricula',
        'PhoneNumber',
        'Usuario',
        'Password',
        'FK_Rol',
        'Status',
        'EmergencyNumber', 
        'BirthDate',
        'FK_Group',
        'CreatedAt',
        'UpdatedAt',
    ];

    public function getUserBy(string $column, string $value){
        return $this->where($column, $value)->first();
    }

   // Función para obtener solo 3 alumnos sin el campo Password
    public function getUsersByRoleOne(){
        return $this->select('PK_User, Name, LastName, Matricula, PhoneNumber, Usuario, FK_Rol, Status, EmergencyNumber, BirthDate, FK_Group, CreatedAt, UpdatedAt')
                    ->where('FK_Rol', 1)
                    ->where('Status', 1)
                    ->orderBy('CreatedAt', 'DESC') 
                    ->limit(3) 
                    ->findAll();
    }


    public function countUsersByRoleOne()
    {
        return $this->where('FK_Rol', 1)->where('Status', 1)->countAllResults();
    }
    
    // Función para obtener solo los 5 estudiantes más recientes: Nombre, Matrícula, y Fecha de Registro
    public function getStudentsSummary(){
        return $this->select('Name, LastName, Matricula, CreatedAt')
                    ->where('FK_Rol', 1)
                    ->where('Status', 1)
                    ->orderBy('CreatedAt', 'DESC') 
                    ->limit(5) 
                    ->findAll();
    }

}
