<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EDUMED</title>
    <link rel="stylesheet" href="<?php echo base_url('css/dashboard.css')?>">
    <link rel="stylesheet" href="<?php echo base_url('css/assing.css')?>">
    <link rel="stylesheet" href="<?php echo base_url('css/timeline/timelineCorrectAnswer.css')?>">
    <link rel="icon" type="image/png" href="<?php echo base_url('img/icon/icon.png')?>">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.dataTables.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    
    <style>
        .page {
            display: none;
        }
        .active {
            display: block;
        }
    </style>
    
</head>

<body>
    <svg style="display:none;">
    <symbol id="down" viewBox="0 0 16 16">
        <polygon points="3.81 4.38 8 8.57 12.19 4.38 13.71 5.91 8 11.62 2.29 5.91 3.81 4.38" />
    </symbol>
    <symbol id="users" viewBox="0 0 16 16">
        <path d="M8,0a8,8,0,1,0,8,8A8,8,0,0,0,8,0ZM8,15a7,7,0,0,1-5.19-2.32,2.71,2.71,0,0,1,1.7-1,13.11,13.11,0,0,0,1.29-.28,2.32,2.32,0,0,0,.94-.34,1.17,1.17,0,0,0-.27-.7h0A3.61,3.61,0,0,1,5.15,7.49,3.18,3.18,0,0,1,8,4.07a3.18,3.18,0,0,1,2.86,3.42,3.6,3.6,0,0,1-1.32,2.88h0a1.13,1.13,0,0,0-.27.69,2.68,2.68,0,0,0,.93.31,10.81,10.81,0,0,0,1.28.23,2.63,2.63,0,0,1,1.78,1A7,7,0,0,1,8,15Z" />
    </symbol>
    <symbol id="collection" viewBox="0 0 16 16">
        <rect width="7" height="7" />
        <rect y="9" width="7" height="7" />
        <rect x="9" width="7" height="7" />
        <rect x="9" y="9" width="7" height="7" />
    </symbol>
    <symbol id="charts" viewBox="0 0 16 16">
        <polygon points="0.64 7.38 -0.02 6.63 2.55 4.38 4.57 5.93 9.25 0.78 12.97 4.37 15.37 2.31 16.02 3.07 12.94 5.72 9.29 2.21 4.69 7.29 2.59 5.67 0.64 7.38" />
        <rect y="9" width="2" height="7" />
        <rect x="12" y="8" width="2" height="8" />
        <rect x="8" y="6" width="2" height="10" />
        <rect x="4" y="11" width="2" height="5" />
    </symbol>
    <symbol id="comments" viewBox="0 0 16 16">
        <path d="M0,16.13V2H15V13H5.24ZM1,3V14.37L5,12h9V3Z" />
        <rect x="3" y="5" width="9" height="1" />
        <rect x="3" y="7" width="7" height="1" />
        <rect x="3" y="9" width="5" height="1" />
    </symbol>
    <symbol id="pages" viewBox="0 0 16 16">
        <rect x="4" width="12" height="12" transform="translate(20 12) rotate(-180)" />
        <polygon points="2 14 2 2 0 2 0 14 0 16 2 16 14 16 14 14 2 14" />
    </symbol>
    <symbol id="appearance" viewBox="0 0 16 16">
        <path d="M3,0V7A2,2,0,0,0,5,9H6v5a2,2,0,0,0,4,0V9h1a2,2,0,0,0,2-2V0Zm9,7a1,1,0,0,1-1,1H9v6a1,1,0,0,1-2,0V8H5A1,1,0,0,1,4,7V6h8ZM4,5V1H6V4H7V1H9V4h1V1h2V5Z" />
    </symbol>
    <symbol id="trends" viewBox="0 0 16 16">
        <polygon points="0.64 11.85 -0.02 11.1 2.55 8.85 4.57 10.4 9.25 5.25 12.97 8.84 15.37 6.79 16.02 7.54 12.94 10.2 9.29 6.68 4.69 11.76 2.59 10.14 0.64 11.85" />
    </symbol>
    <symbol id="settings" viewBox="0 0 16 16">
        <rect x="9.78" y="5.34" width="1" height="7.97" />
        <polygon points="7.79 6.07 10.28 1.75 12.77 6.07 7.79 6.07" />
        <rect x="4.16" y="1.75" width="1" height="7.97" />
        <polygon points="7.15 8.99 4.66 13.31 2.16 8.99 7.15 8.99" />
        <rect x="1.28" width="1" height="4.97" />
        <polygon points="3.28 4.53 1.78 7.13 0.28 4.53 3.28 4.53" />
        <rect x="12.84" y="11.03" width="1" height="4.97" />
        <polygon points="11.85 11.47 13.34 8.88 14.84 11.47 11.85 11.47" />
    </symbol>

    <symbol id="options" viewBox="0 0 16 16">
        <path d="M8,11a3,3,0,1,1,3-3A3,3,0,0,1,8,11ZM8,6a2,2,0,1,0,2,2A2,2,0,0,0,8,6Z" />
        <path d="M8.5,16h-1A1.5,1.5,0,0,1,6,14.5v-.85a5.91,5.91,0,0,1-.58-.24l-.6.6A1.54,1.54,0,0,1,2.7,14L2,13.3a1.5,1.5,0,0,1,0-2.12l.6-.6A5.91,5.91,0,0,1,2.35,10H1.5A1.5,1.5,0,0,1,0,8.5v-1A1.5,1.5,0,0,1,1.5,6h.85a5.91,5.91,0,0,1,.24-.58L2,4.82A1.5,1.5,0,0,1,2,2.7L2.7,2A1.54,1.54,0,0,1,4.82,2l.6.6A5.91,5.91,0,0,1,6,2.35V1.5A1.5,1.5,0,0,1,7.5,0h1A1.5,1.5,0,0,1,10,1.5v.85a5.91,5.91,0,0,1,.58.24l.6-.6A1.54,1.54,0,0,1,13.3,2L14,2.7a1.5,1.5,0,0,1,0,2.12l-.6.6a5.91,5.91,0,0,1,.24.58h.85A1.5,1.5,0,0,1,16,7.5v1A1.5,1.5,0,0,1,14.5,10h-.85a5.91,5.91,0,0,1-.24.58l.6.6a1.5,1.5,0,0,1,0,2.12L13.3,14a1.54,1.54,0,0,1-2.12,0l-.6-.6a5.91,5.91,0,0,1-.58.24v.85A1.5,1.5,0,0,1,8.5,16ZM5.23,12.18l.33.18a4.94,4.94,0,0,0,1.07.44l.36.1V14.5a.5.5,0,0,0,.5.5h1a.5.5,0,0,0,.5-.5V12.91l.36-.1a4.94,4.94,0,0,0,1.07-.44l.33-.18,1.12,1.12a.51.51,0,0,0,.71,0l.71-.71a.5.5,0,0,0,0-.71l-1.12-1.12.18-.33a4.94,4.94,0,0,0,.44-1.07l.1-.36H14.5a.5.5,0,0,0,.5-.5v-1a.5.5,0,0,0-.5-.5H12.91l-.1-.36a4.94,4.94,0,0,0-.44-1.07l-.18-.33L13.3,4.11a.5.5,0,0,0,0-.71L12.6,2.7a.51.51,0,0,0-.71,0L10.77,3.82l-.33-.18a4.94,4.94,0,0,0-1.07-.44L9,3.09V1.5A.5.5,0,0,0,8.5,1h-1a.5.5,0,0,0-.5.5V3.09l-.36.1a4.94,4.94,0,0,0-1.07.44l-.33.18L4.11,2.7a.51.51,0,0,0-.71,0L2.7,3.4a.5.5,0,0,0,0,.71L3.82,5.23l-.18.33a4.94,4.94,0,0,0-.44,1.07L3.09,7H1.5a.5.5,0,0,0-.5.5v1a.5.5,0,0,0,.5.5H3.09l.1.36a4.94,4.94,0,0,0,.44,1.07l.18.33L2.7,11.89a.5.5,0,0,0,0,.71l.71.71a.51.51,0,0,0,.71,0Z" />
    </symbol>
    <symbol id="collapse" viewBox="0 0 16 16">
        <polygon points="11.62 3.81 7.43 8 11.62 12.19 10.09 13.71 4.38 8 10.09 2.29 11.62 3.81" />
    </symbol>
    <symbol id="search" viewBox="0 0 16 16">
        <path d="M6.57,1A5.57,5.57,0,1,1,1,6.57,5.57,5.57,0,0,1,6.57,1m0-1a6.57,6.57,0,1,0,6.57,6.57A6.57,6.57,0,0,0,6.57,0Z" />
        <rect x="11.84" y="9.87" width="2" height="5.93" transform="translate(-5.32 12.84) rotate(-45)" />
    </symbol>
    </svg>
    <header class="page-header">
    <nav>
    <a href="<?= base_url('dashboard'); ?>" aria-label="forecastr logo" class="logo">
        <img src="<?php echo base_url('img/logo/logo.png'); ?>" alt="Logo" width="180" height="100">
        </a>
        <button class="toggle-mob-menu" aria-expanded="false" aria-label="open menu">
        <svg width="20" height="20" aria-hidden="true">
            <use xlink:href="#down"></use>
        </svg>
        </button>
        <ul class="admin-menu">
        <li class="menu-heading">
            <h3><?= session('Username') ?></h3>
        </li>
        <li class="<?= (current_url() == base_url('test')) ? 'active' : '' ?>">
        <a href="<?= base_url('test'); ?>">
        <svg>
                <use xlink:href="#pages"></use>
            </svg>
            <span>Exámenes</span>
            </a>
        </li>
        <li>
        <a href="<?= base_url('info'); ?>">
            <svg>
                <use xlink:href="#users"></use>
            </svg>
            <span>Mi información</span>
            </a>
        </li>
        <li>
        <a href="<?= base_url('recordedclasses'); ?>">
            <svg>
                <use xlink:href="#collection"></use>
            </svg>
            <span>Clases grabadas</span>
        </a>
        </li>
        <li>
    <a href="<?= base_url('materialeduc'); ?>">
        <svg>
            <use xlink:href="#pages"></use>
        </svg>
        <span>Material educativo</span>
    </a>
        </li>
        <li class="menu-heading">
            <h3>Ajustes</h3>
        </li>
        <li>
            <a href="<?= base_url('settings'); ?>">
                <svg>
                    <use xlink:href="#settings"></use>
                </svg>
                <span>Ajustes</span>
            </a>
        </li>
        <li>
    <a href="<?= base_url('tickets'); ?>">
        <svg>
            <use xlink:href="#comments"></use>
        </svg>
        <span>Tickets</span>
        </a>
    </li>
    <li>
        <li>
            <a href="<?= base_url('logout') ?>">
            <svg width="32" height="32">
            <use xlink:href="#users"></use>
            </svg>
            <span>Cerrar sesión</span>
            </a>
        </li>
        <li>
            <div class="switch">
            <input type="checkbox" id="mode" checked>
            <label for="mode">
                <span></span>
                <span>Noche</span>
            </label>
            </div>
            <button class="collapse-btn" aria-expanded="true" aria-label="collapse menu">
            <svg aria-hidden="true">
                <use xlink:href="#collapse"></use>
            </svg>
            <span>Contraer</span>
            </button>
        </li>
        </ul>
    </nav>
    </header>

    <?php if (session()->get('FK_Rol') == 2 || session()->get('FK_Rol') == 3): ?>
    <section class="page-content">
        <section class="dashboard">

        <h2>Asignar Preguntas al Examen</h2>

        <input type="hidden" value=" ID <?= esc($testId); ?>"></input>

        <!-- Mostrar mensajes de éxito o error -->
        <?php if (session()->get('success')): ?>
            <div class="alert alert-success"><?= session('success'); ?></div>
        <?php endif; ?>

        <?php if (session()->get('error')): ?>
            <div class="alert alert-danger"><?= session('error'); ?></div>
        <?php endif; ?>

        <!-- Formulario para seleccionar el tipo de pregunta -->
        <form id="styledForm">
            <div class="form-group">
                <label for="questionType">Selecciona el tipo de pregunta</label>
                <select id="questionType" name="questionType" class="form-control" required onchange="showNextForm()">
                    <option value="">-- Selecciona --</option>
                    <option value="captura_respuesta">Captura la respuesta</option>
                    <option value="multiple_opciones">Múltiples opciones</option>
                    <option value="encuentra_error">Encuentra el error</option>
                    <option value="Gramatica">Gramática</option>
                    <option value="Matematicas">Ejercios matematicos/fisica</option>
                    <option value="Categorias">Dos o más categorias</option>
                    <option value="timeline">Linea de Tiempo</option>
                    <option value="multiple_Correct">Mas de una respuesta</option>
                </select>
            </div>
        </form>

        <!-- Formulario para "Captura la respuesta" (oculto al inicio) -->
        <form id="captureResponseForm" method="post" action="<?= site_url('questions/createCaptureQuestion') ?>" enctype="multipart/form-data" style="display:none;">
            <input type="hidden" name="testId" value="<?= esc($testId); ?>">
            <input type="hidden" name="questionType" value="captura_respuesta">

            <div class="form-group">
                <label for="question">Escribe la pregunta:</label>
                <input type="text" id="question" name="question" class="form-control" required>
            </div>

            <div class="form-group">
                <label for="Instructions">Instrucciones:</label>
                <input type="text" id="Instructions" name="Instructions" class="form-control" required>
            </div>

            <div class="form-group">
                <label for="correctAnswer">Respuesta correcta:</label>
                <input type="text" id="correctAnswer" name="correctAnswer" class="form-control" required>
            </div>

            <div id="answerFields"></div>

            <div class="form-group">
                <label for="subject">Materia:</label>
                <input type="text" id="subject" name="subject" class="form-control" required>
            </div>

            <div class="form-group">
                <label for="material">Carga un material (imagen):</label>
                <input type="file" id="material" name="material" class="form-control" accept="image/*">
            </div>

            <button type="submit" id="createStudent">Enviar</button>
        </form>

        <!-- Formulario para "Múltiples opciones" (oculto al inicio) -->
        <form id="multipleOptionsForm" method="post" action="<?= site_url('questions/createMultipleChoiceQuestion') ?>" enctype="multipart/form-data" style="display:none;">
            <input type="hidden" name="testId" value="<?= esc($testId); ?>">
            
            <!-- Campos específicos de múltiples opciones -->
            <div class="form-group">
                <label for="multipleQuestion">Escribe la pregunta:</label>
                <input type="text" id="multipleQuestion" name="multipleQuestion" class="form-control" required>
            </div>

            <!-- Otros campos para este tipo de pregunta -->
            
            <button type="submit" class="btn btn-primary">Enviar</button>
        </form>

        <!-- Formulario para "Encuentra el error" (oculto al inicio) -->
        <form id="findErrorForm" method="post" action="<?= site_url('questions/createFindErrorQuestion') ?>" enctype="multipart/form-data" style="display:none;">
            <input type="hidden" name="testId" value="<?= esc($testId); ?>">
            
            <!-- Campos específicos de Encuentra el error -->
            <div class="form-group">
                <label for="errorQuestion">Escribe la pregunta:</label>
                <input type="text" id="errorQuestion" name="errorQuestion" class="form-control" required>
            </div>

            <!-- Otros campos para este tipo de pregunta -->
            
            <button type="submit" id="createStudent">Enviar</button>
        </form>


    <!-- Formulario para "Gramática" (oculto al inicio) -->
    <form id="grammarForm" method="post" action="<?= site_url('questions/createGrammarQuestion') ?>" enctype="multipart/form-data" style="display:none;">
        <input type="hidden" name="testId" value="<?= esc($testId); ?>">
        <input type="hidden" name="questionType" value="Gramatica">

        <!-- Campo para la pregunta -->
        <div class="form-group">
            <label for="question">Escribe la pregunta:</label>
            <input type="text" id="question" name="question" class="form-control" required>
        </div>

        <!-- Campo para las instrucciones -->
        <div class="form-group">
            <label for="instructions">Instrucciones:</label>
            <input type="text" id="instructions" name="instructions" class="form-control" required>
        </div>

        <!-- Opciones de respuestas -->
        <div class="form-group">
            <label for="Option1">Opción 1 (Posible error gramatical):</label>
            <input type="text" id="Option1" name="option1" class="form-control" required>
        </div>

        <div class="form-group">
            <label for="Option2">Opción 2 (Posible error gramatical):</label>
            <input type="text" id="Option2" name="option2" class="form-control" required>
        </div>

        <div class="form-group">
            <label for="Option3">Opción 3 (Posible error gramatical):</label>
            <input type="text" id="Option3" name="option3" class="form-control" required>
        </div>

        <div class="form-group">
            <label for="Option4">Opción 4 (Posible error gramatical):</label>
            <input type="text" id="Option4" name="option4" class="form-control" required>
        </div>

        <!-- Campo para la respuesta correcta -->
        <div class="form-group">
            <label for="correctAnswer">Respuesta correcta:</label>
            <input type="text" id="correctAnswer" name="correctAnswer" class="form-control" required>
        </div>

        <!-- Campo para la materia -->
        <div class="form-group">
            <label for="subject">Materia:</label>
            <input type="text" id="subject" name="subject" class="form-control" required>
        </div>


        <!-- Botón de envío -->
        <button type="submit" id="createStudent">Enviar</button>
    </form>

<!-- Formulario para "Matemáticas" (oculto al inicio) -->
<form id="mathForm" method="post" action="<?= site_url('questions/createMathQuestion') ?>" enctype="multipart/form-data" style="display:none;">
    <input type="hidden" name="testId" value="<?= esc($testId); ?>">
    <input type="hidden" name="questionType" value="Matematicas">

    <!-- Campo para la pregunta -->
    <div class="form-group">
        <label for="question">Escribe la pregunta/ejercicio:</label>
        <input type="text" id="question" name="question" class="form-control" required>
    </div>

    <!-- Campo para las instrucciones -->
    <div class="form-group">
        <label for="instructions">Instrucciones:</label>
        <input type="text" id="instructions" name="instructions" class="form-control" required>
    </div>

    <!-- Opciones de respuestas (la opción 1 es obligatoria, las demás opcionales) -->
    <div class="form-group">
        <label for="Option1">Opción 1 (obligatoria):</label>
        <input type="text" id="Option1" name="option1" class="form-control" required>
    </div>

    <div class="form-group">
        <label for="Option2">Opción 2 (opcional):</label>
        <input type="text" id="Option2" name="option2" class="form-control" placeholder="Este campo es en caso de que tu pregunta/ejercicio requiera más de 1 opción">
    </div>

    <div class="form-group">
        <label for="Option3">Opción 3 (opcional):</label>
        <input type="text" id="Option3" name="option3" class="form-control" placeholder="Este campo es en caso de que tu pregunta/ejercicio requiera más de 1 opción">
    </div>

    <div class="form-group">
        <label for="Option4">Opción 4 (opcional):</label>
        <input type="text" id="Option4" name="option4" class="form-control" placeholder="Este campo es en caso de que tu pregunta/ejercicio requiera más de 1 opción">
    </div>

    <!-- Campo para la respuesta correcta -->
    <div class="form-group">
        <label for="correctAnswer">Respuesta correcta:</label>
        <input type="text" id="correctAnswer" name="correctAnswer" class="form-control" required>
    </div>

    <!-- Campo para la materia -->
    <div class="form-group">
        <label for="subject">Materia:</label>
        <input type="text" id="subject" name="subject" class="form-control" required>
    </div>

    <div class="form-group">
        <label for="material">Carga un material (imagen):</label>
        <input type="file" id="material" name="material" class="form-control" accept="image/*">
    </div>

    <!-- Botón de envío -->
    <button type="submit" id="createStudent" class="btn btn-primary">Enviar</button>
</form>

        <form id="categoryQuestionForm" method="post" action="<?= site_url('questions/createCategoryQuestion') ?>" enctype="multipart/form-data" style="display:none;">
            <input type="hidden" name="testId" value="<?= esc($testId); ?>">
            <input type="hidden" name="questionType" value="Categories">

            <div class="form-group">
                <label for="question">Escribe la pregunta:</label>
                <input type="text" id="question" name="question" class="form-control" required>
            </div>

            <div class="form-group">
                <label for="instructions">Instrucciones:</label>
                <input type="text" id="instructions" name="instructions" class="form-control" required>
            </div>

        <!-- Contenedor para categoría 1 -->
        <div class="form-group">
            <label for="category1">Categoría 1 (obligatoria):</label>
            <input type="text" id="category1" name="category1" class="form-control" required>
            <div id="items_category1" class="items-container">
                <input type="text" name="items_category1[]" class="form-control" placeholder="Agregar ítem a Categoría 1">
            </div>
            <button type="button" onclick="addItemField('items_category1')">Añadir Ítem a Categoría 1</button>
        </div>

        <!-- Contenedor para categoría 2 -->
        <div class="form-group">
            <label for="category2">Categoría 2 (opcional):</label>
            <input type="text" id="category2" name="category2" class="form-control">
            <div id="items_category2" class="items-container">
                <input type="text" name="items_category2[]" class="form-control" placeholder="Agregar ítem a Categoría 2">
            </div>
            <button type="button" onclick="addItemField('items_category2')">Añadir Ítem a Categoría 2</button>
        </div>


            <button type="submit" id="createStudent">Enviar</button>
        </form>

        <!-- Formulario para "timeline" (oculto al inicio) -->
        <form id="timeline" enctype="multipart/form-data" style="display:none;">
            <input type="hidden" name="testId" value="<?= esc($testId); ?>">
            
            <div class="form-group">
                <label for="timelineQuestion">Escribe la pregunta:</label>
                <input type="text" id="timelineQuestion" name="timelineQuestion" class="form-control" required>
            </div>

            <div class="form-group">
                <label for="timelineQuestion">Materia de la pregunta:</label>
                <input type="text" id="subjectQuestion" name="subjectQuestion" class="form-control" required>
            </div>
            
            <div class="form-group">
                <label for="timelineQuestion">Instrucciones:</label>
                <input type="text" id="instructions" name="instructions" class="form-control" required>
            </div>

            <div class="form-group">
                <label for="TimelineMaterial">Carga un material (imagen):</label>
                <input type="file" id="TimelineMaterial" name="TimelineMaterial" class="form-control" accept="image/*">
            </div>

            <button type="submit" class="btn-simple" id="submit-timeline">Enviar</button>
        </form>

        <form id="timeline_questions" enctype="multipart/form-data" style="display:none;">
            <input type="hidden" id="questionId" name="questionId" value="">

            <div id="event-container">
                <div class="form-group">
                    <label for="timelineQuestion">Escribe el evento:</label>
                    <input type="text" id="timelineQuestion" name="timelineQuestion[]" class="form-control" required>
                </div>
            </div>

            <!-- Botón para agregar más eventos -->
            <button type="button" class="btn-simple" id="eventBtn" onclick="addEvent()">Añadir otro evento</button>

            <button class="btn-simple" type="submit" id="saveEvent">Enviar</button>
        </form>

        <button type="button" id="openModalButton" class="btn-simple" style="display:none;">Asignar respuestas correctas</button>
        
        <!-- Modal -->
        <div id="modal" style="display: none;">
            <form id="timeline_form">
                <div class="modal-content table-responsive">
                    <span id="closeModal" style="cursor:pointer;">&times;</span>
                    <h2>Asignar Respuestas Correctas</h2>
                    <table id="eventsTable" class="display" style="width: 100%">
                        <thead>
                            <tr>
                                <th>Evento</th>
                                <th>Asignar Número</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                    <button type="submit" id="timeline_correct">Guardar</button>
                </div>
            </form>
        </div>

        <!-- Formulario para "Mas de una respuesta" (oculto al inicio) -->
        <form id="multipleCorrectForm" enctype="multipart/form-data" style="display:none;">
            <input type="hidden" name="TestId" value="<?= esc($testId); ?>">
            <div class="form-group">
                <label for="question">Escribe la pregunta:</label>
                <input type="text" id="question" name="Question" class="form-control" required>
            </div>

            <div class="form-group">
                <label for="Instructions">Instrucciones:</label>
                <input type="text" id="Instructions" name="Instructions" class="form-control" required>
            </div>

            <div class="form-group" id="correctAnswersContainer">
                <label>Respuestas correctas:</label>
                <div class="correct-answer-group">
                    <input type="text" name="correctAnswer[]" class="form-control" required>
                </div>
            </div>

            <button type="button" id="addCorrectAnswer">Agregar otra respuesta correcta</button>

            <div class="form-group">
                <label for="subject">Materia:</label>
                <input type="text" id="subject" name="Subject" class="form-control" required>
            </div>

            <div class="form-group">
                <label for="Material">Carga un material (imagen):</label>
                <input type="file" id="Material" name="Material" class="form-control" accept="image/*">
            </div>

            <button type="submit" id="createStudent">Enviar</button>
        </form>

        </section>
    </section>
<?php endif; ?>



<?php if (session()->get('FK_Rol') == 1): ?>

    <h1>Alumno</h1>

    <?php return redirect()->to('/dashboard'); ?>

<?php endif; ?>


</body>
</html>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="<?=base_url()?>js/dashboard/dashboard.js"></script>
<script src="<?=base_url()?>js/test/test.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/js/bootstrap-select.min.js"></script>
<script src="<?php echo base_url('js/timeline/timelineCorrectAnswer.js')?>"></script>

<script>
    var baseUrl = "<?= base_url() ?>";
    var userId = "<?= session()->get('PK_User') ?>";
    var createCaptureQuestionURL = baseUrl + "/questions/createCaptureQuestion";
    var createGrammarQuestionURL = "<?= site_url('questions/createGrammarQuestion') ?>";
    var createMathQuestionURL = "<?= site_url('questions/createMathQuestion') ?>";
    const createCategoryQuestionURL = "<?= site_url('questions/createCategoryQuestion') ?>";
    var testURL = baseUrl + "/test";
</script>

<script>
// Función para añadir un nuevo campo de ítem
function addItemField(containerId) {
    const container = document.getElementById(containerId);
    const newItemField = document.createElement('input');
    newItemField.type = 'text';
    newItemField.name = containerId + '[]'; // Añadir el array al nombre
    newItemField.classList.add('form-control');
    container.appendChild(newItemField);
}

</script>

<script>
    //send timeline events form
    $(document).ready(function() {
        $('#multipleCorrectForm').on('submit', function(event) {
            event.preventDefault(); // Prevenir el envío del formulario y la recarga de la página
            var formData = new FormData(this);
            console.log(formData);
            // Hacer la llamada AJAX
            $.ajax({
                url: '<?php echo base_url('questions/createMultipleAnswer') ?>', // Aquí se usa site_url
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                dataType: 'json',

                success: function(response) {
                    if (response.status === 'success') {
                        Swal.fire({
                            title: 'Éxito',
                            text: response.message,
                            icon: 'success',
                            confirmButtonText: 'Aceptar'
                        }).then(() => {
                            document.getElementById('multipleCorrectForm').reset();
                        });
                    } else {
                        Swal.fire({
                            title: 'Error',
                            text: response.message || 'Ocurrió un error inesperado.',
                            icon: 'error',
                            confirmButtonText: 'Aceptar'
                        });
                    }
                },
                error: function(xhr, status, error) {
                    Swal.fire({
                        title: 'Error',
                        text: 'Ha ocurrido un error: ' + error,
                        icon: 'error',
                        confirmButtonText: 'Aceptar'
                    });
                }
            });
        });
    });
</script>


<script>//open Modal w questions
document.getElementById("openModalButton").onclick = function() {
    document.getElementById("modal").style.display = "block";

    var pkQuestion = $('#questionId').val();

    $.ajax({
            url: '<?php echo base_url('timeline/getEvents/') ?>' + pkQuestion,
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                console.log(data);

                $('#eventsTable tbody').empty();

                // Recorrer los datos recibidos
                $.each(data, function(index, event) {
                    // Crear una nueva fila para cada evento
                    var newRow = '<tr>' +
                        '<td class="centered-cell"><input type="hidden" name="FK_Event[]" value="'+ event.PK_Timeline_Event +'" ></td>' +
                        '<td class="centered-cell"><input type="" name="EventDescription[]" value="'+ event.Event_Description +'" readonly></td>' + // Insertar nombre del evento
                        '<td class="centered-cell"><input type="number" name="Correct_Order[]" ></td>' + // Input adicional
                        '<td class="centered-cell"><input type="hidden" name="FK_Question[]" value="'+ pkQuestion+'" ></td>' +
                    '</tr>';

                    // Añadir la fila a la tabla
                    $('#eventsTable tbody').append(newRow);
                });
            }
        });
}

document.getElementById("closeModal").onclick = function() {
    document.getElementById("modal").style.display = "none";
}


</script>

<script>
    //send timeline events form
    $(document).ready(function() {
        $('#timeline_form').on('submit', function(event) {
            event.preventDefault(); // Prevenir el envío del formulario y la recarga de la página
            var formData = $(this).serialize();
            // Hacer la llamada AJAX
            $.ajax({
                url: '<?php echo base_url('timeline/saveOrder') ?>', // Aquí se usa site_url
                type: 'POST',
                data: formData,
                dataType: 'json',

                success: function(response) {
                    if (response.status === 'success') {
                        Swal.fire({
                            title: 'Éxito',
                            text: response.message,
                            icon: 'success',
                            confirmButtonText: 'Aceptar'
                        }).then(() => {
                            document.getElementById("modal").style.display = "none";
                        });
                    } else {
                        Swal.fire({
                            title: 'Error',
                            text: response.message || 'Ocurrió un error inesperado.',
                            icon: 'error',
                            confirmButtonText: 'Aceptar'
                        });
                    }
                },
                error: function(xhr, status, error) {
                    Swal.fire({
                        title: 'Error',
                        text: 'Ha ocurrido un error: ' + error,
                        icon: 'error',
                        confirmButtonText: 'Aceptar'
                    });
                }
            });
        });
    });
</script>


<script>
function addEvent() {
    // Crear un nuevo div para el grupo de eventos
    let newEventDiv = document.createElement('div');
    newEventDiv.classList.add('form-group');

    // Crear una nueva etiqueta (label) para el nuevo input
    let newLabel = document.createElement('label');
    newLabel.textContent = 'Escribe el evento:';

    // Crear un nuevo input para el evento
    let newInput = document.createElement('input');
    newInput.type = 'text';
    newInput.name = 'timelineQuestion[]';  // Agregar [] para enviar múltiples valores como array
    newInput.classList.add('form-control');
    newInput.required = true;

    // Agregar el label y el input al nuevo div
    newEventDiv.appendChild(newLabel);
    newEventDiv.appendChild(newInput);

    // Agregar el nuevo div al contenedor de eventos
    document.getElementById('event-container').appendChild(newEventDiv);
}
</script>

<script>
    //send timeline form
    $(document).ready(function() {
        $('#timeline').on('submit', function(event) {
            event.preventDefault(); // Prevenir el envío del formulario y la recarga de la página

            // Recolectar datos del formulario
            var formData = $(this).serialize();

            // Hacer la llamada AJAX
            $.ajax({
                url: '<?= site_url('timeline/timelineCreateQuestion') ?>', // Aquí se usa site_url
                type: 'POST',
                data: formData,
                dataType: 'json',
                success: function(response) {
                    if (response.status === 'success') {
                        $('#questionId').val(response.PK_Question);
                        $('#submit-timeline').prop('disabled', true);
                        $('#timelineQuestion').prop('disabled', true);
                        $('#subjectQuestion').prop('disabled', true);
                        Swal.fire({
                            title: 'Éxito',
                            text: response.message,
                            icon: 'success',
                            confirmButtonText: 'Aceptar'
                        }).then(() => {
                            
                        });
                    } else {
                        Swal.fire({
                            title: 'Error',
                            text: response.message || 'Ocurrió un error inesperado.',
                            icon: 'error',
                            confirmButtonText: 'Aceptar'
                        });
                    }
                },
                error: function(xhr, status, error) {
                    Swal.fire({
                        title: 'Error',
                        text: 'Ha ocurrido un error: ' + error,
                        icon: 'error',
                        confirmButtonText: 'Aceptar'
                    });
                }
            });
        });
    });
</script>

<script>
    //send timeline events form
    $(document).ready(function() {
        $('#timeline_questions').on('submit', function(event) {
            event.preventDefault(); // Prevenir el envío del formulario y la recarga de la página

            // Recolectar datos del formulario
            var formData = $(this).serialize();

            // Hacer la llamada AJAX
            $.ajax({
                url: '<?= site_url('timeline/saveEvents') ?>', // Aquí se usa site_url
                type: 'POST',
                data: formData,
                dataType: 'json',
                success: function(response) {
                    if (response.status === 'success') {
                        $('#saveEvent').prop('disabled', true);
                        $('#eventBtn').prop('disabled', true);
                        $('#openModalButton').prop('disabled', false);
                        let elements = document.getElementsByName("timelineQuestion[]");
                        for (let i = 0; i < elements.length; i++) {
                            elements[i].disabled = true;
                        }
                        Swal.fire({
                            title: 'Éxito',
                            text: response.message,
                            icon: 'success',
                            confirmButtonText: 'Aceptar'
                        }).then(() => {
                        });
                    } else {
                        Swal.fire({
                            title: 'Error',
                            text: response.message || 'Ocurrió un error inesperado.',
                            icon: 'error',
                            confirmButtonText: 'Aceptar'
                        });
                    }
                },
                error: function(xhr, status, error) {
                    Swal.fire({
                        title: 'Error',
                        text: 'Ha ocurrido un error: ' + error,
                        icon: 'error',
                        confirmButtonText: 'Aceptar'
                    });
                }
            });
        });
    });
</script>

<script>
        document.addEventListener('DOMContentLoaded', function () {
            <?php if (session()->getFlashdata('success')): ?>
                Swal.fire({
                    title: 'Exito!!',
                    text: '<?= session()->getFlashdata('success') ?>',
                    icon: 'success',
                    confirmButtonText: 'OK'
                });
            <?php endif; ?>

            <?php if (session()->getFlashdata('error')): ?>
                Swal.fire({
                    title: 'Error!',
                    text: '<?= session()->getFlashdata('error') ?>',
                    icon: 'error',
                    confirmButtonText: 'OK'
                });
            <?php endif; ?>
            <?php if (session()->getFlashdata('info')): ?>
                Swal.fire({
                    title: 'Error!',
                    text: '<?= session()->getFlashdata('info') ?>',
                    icon: 'info',
                    confirmButtonText: 'OK'
                });
            <?php endif; ?>
        });
</script>

