<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EduMed</title>
    <link rel="stylesheet" href="<?php echo base_url('css/reviews/reviews.css?v='.time()) ?>">
    <link rel="icon" type="image/png" href="<?php echo base_url('img/icon/icon.png')?>">

</head>
<body>
    <div class="landing-page">
        <header>
          <div class="container">
            <a href="" class="logo" >
              <img src="<?php echo base_url('img/logo/Edumed1.jpeg'); ?>" alt="">
            </a>
            <ul class="links">
              <li><a href="#" id="home-link">Inicio</a></li>
              <li><a href="#" id="about-link">Sobre Nosotros</a></li>
              <li><a href="#" id="reviews-link">Reseñas</a></li>
              <li class='last-li'><a class="login-btn" href="<?php echo base_url('/login'); ?>">Iniciar Sesión</a></li>
            </ul>
          </div>
        </header>

        <!-- Home Content -->
        <div id="home-content" class="content">
          <div class="container">
            <div class="info">
              <h1>EduMed</h1>
              <p>Curso de preparación propedéutico + excoba para la facultad de medicina UAQ</p>
              <button>INSCRÍBETE</button>
            </div>
            <div class="image">
              <img src="<?php echo base_url('img/classroom.jpeg'); ?>">
            </div>
          </div>
        </div>

        <!-- About Us Content (Hidden by default) -->
        <div id="about-content" class="content" style="display: none;">
          <div class="container">
            <div class="image2">
              <img src="<?php echo base_url('img/EDUMEDINFO.jpeg'); ?>">
            </div>
            <div class="info1">
    <h1>Sobre Nosotros</h1>
    <ul>
        <li>Alta Eficacia</li>
        <li>Atención Perzonalizada</li>
        <li>Grupos Reducidos</li>
        <li>Sesiones Dirigidas</li>
        <li>Máximo Aprovechamiento Académico</li>
        <li>Diagnóstico y Módulos con Evaluaciones Excoba</li>
        <li>Evaluaciones Excoba</li>
        <li>Plataforma Digital</li>
    </ul>
</div>
          </div>
        </div>
      </div>

      <!-- About Us Content (Hidden by default) -->
      <div id="reviews-content" class="content" style="display: none;">
          <div class="container container-reviews">
          <div class="content-wrapper">
		<h2>Reseñas</h2>
		<div class="blue-line"></div>
		<div class="wrapper-for-arrows">
			<div style="opacity: 0;" class="chicken"></div>
			<div id="reviewWrap" class="review-wrap">
				<div id="imgDiv" class="">
				</div>
				<div id="personName"></div>
				<div id="profession"></div>
				<div id="description">
				</div>
			</div>
			<div class="left-arrow-wrap arrow-wrap">
				<div class="arrow" id="leftArrow"></div>
			</div>
			<div class="right-arrow-wrap arrow-wrap">
				<div class="arrow" id="rightArrow"></div>
			</div>
		</div>
	</div>
          </div>
        </div>
      </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.9.1/gsap.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>
    <script src="<?php echo base_url('js/reviews/reviews.js?v='.time()) ?>"></script>
    
    <script>
      $(document).ready(function() {
        // Maneja el clic en el enlace "Home"
        $('#home-link').on('click', function(e) {
          e.preventDefault();
          $('#home-content').show();
          $('#about-content').hide();
          $('#reviews-content').hide();
        });

        // Maneja el clic en el enlace "About Us"
        $('#about-link').on('click', function(e) {
          e.preventDefault();
          $('#about-content').show();
          $('#home-content').hide();
          $('#reviews-content').hide();
        });

        // Maneja el clic en el enlace "reviews"
        $('#reviews-link').on('click', function(e) {
          e.preventDefault();
          $('#reviews-content').show();
          $('#home-content').hide();
          $('#about-content').hide();
        });
      });
    </script>
    <script>
    let baseUrl = "<?php echo base_url(); ?>";
</script>

<script>
    let people = [
        <?php foreach ($reviews as $review): ?>
            {
                photo: "<?= esc($review['photo']) ?>",  // Solo la URL
                name: "<?php echo $review['Name']; ?>",
                profession: "<?php echo $review['Date']; ?>",
                description: "<?php echo $review['Description']; ?>"
            },
        <?php endforeach; ?>
    ];

    const reviewWrap = document.getElementById("reviewWrap");
    const leftArrow = document.getElementById("leftArrow");
    const rightArrow = document.getElementById("rightArrow");
    const imgDiv = document.getElementById("imgDiv");
    const personName = document.getElementById("personName");
    const profession = document.getElementById("profession");
    const description = document.getElementById("description");
    const surpriseMeBtn = document.getElementById("surpriseMeBtn");
    const chicken = document.querySelector(".chicken");

    let isChickenVisible = false;

    // Usar backgroundImage con formato `url()`
    imgDiv.style.backgroundImage = `url(${people[0].photo})`;
    personName.innerText = people[0].name;
    profession.innerText = people[0].profession;
    description.innerText = people[0].description;
    let currentPerson = 0;

    function slide(whichSide, personNumber) {
        let reviewWrapWidth = reviewWrap.offsetWidth + "px";
        let descriptionHeight = description.offsetHeight + "px";
        let side1symbol = whichSide === "left" ? "" : "-";
        let side2symbol = whichSide === "left" ? "-" : "";

        let tl = gsap.timeline();

        if (isChickenVisible) {
            tl.to(chicken, { duration: 0.4, opacity: 0 });
        }

        tl.to(reviewWrap, { duration: 0.4, opacity: 0, translateX: `${side1symbol + reviewWrapWidth}` });
        tl.to(reviewWrap, { duration: 0, translateX: `${side2symbol + reviewWrapWidth}` });

        setTimeout(() => {
            // Actualiza la imagen del fondo con la URL
            imgDiv.style.backgroundImage = `url(${people[personNumber].photo})`;
            personName.innerText = people[personNumber].name;
            profession.innerText = people[personNumber].profession;
            description.innerText = people[personNumber].description;
        }, 400);

        tl.to(reviewWrap, { duration: 0.4, opacity: 1, translateX: 0 });

        if (isChickenVisible) {
            tl.to(chicken, { duration: 0.4, opacity: 1 });
        }
    }

    function setNextCardLeft() {
        currentPerson = (currentPerson === 3) ? 0 : currentPerson + 1;
        slide("left", currentPerson);
    }

    function setNextCardRight() {
        currentPerson = (currentPerson === 0) ? 3 : currentPerson - 1;
        slide("right", currentPerson);
    }

    leftArrow.addEventListener("click", setNextCardLeft);
    rightArrow.addEventListener("click", setNextCardRight);

    surpriseMeBtn.addEventListener("click", () => {
        if (chicken.style.opacity === "0") {
            chicken.style.opacity = "1";
            imgDiv.classList.add("move-head");
            surpriseMeBtn.innerText = "Remove the chicken";
            isChickenVisible = true;
        } else {
            chicken.style.opacity = "0";
            imgDiv.classList.remove("move-head");
            surpriseMeBtn.innerText = "Surprise me";
            isChickenVisible = false;
        }
    });

    window.addEventListener("resize", () => {
        description.style.height = "100%";
    });
</script>

</body>
</html>
