<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EDUMED</title>
    <link rel="stylesheet" href="<?php echo base_url('css/dashboard.css')?>">
    <link rel="stylesheet" href="<?php echo base_url('css/StartExam.css?v='.time())?>">
    <link rel="icon" type="image/png" href="<?php echo base_url('img/icon/icon.png')?>">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.dataTables.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    
    
</head>

<body>
    <svg style="display:none;">
    <symbol id="down" viewBox="0 0 16 16">
        <polygon points="3.81 4.38 8 8.57 12.19 4.38 13.71 5.91 8 11.62 2.29 5.91 3.81 4.38" />
    </symbol>
    <symbol id="users" viewBox="0 0 16 16">
        <path d="M8,0a8,8,0,1,0,8,8A8,8,0,0,0,8,0ZM8,15a7,7,0,0,1-5.19-2.32,2.71,2.71,0,0,1,1.7-1,13.11,13.11,0,0,0,1.29-.28,2.32,2.32,0,0,0,.94-.34,1.17,1.17,0,0,0-.27-.7h0A3.61,3.61,0,0,1,5.15,7.49,3.18,3.18,0,0,1,8,4.07a3.18,3.18,0,0,1,2.86,3.42,3.6,3.6,0,0,1-1.32,2.88h0a1.13,1.13,0,0,0-.27.69,2.68,2.68,0,0,0,.93.31,10.81,10.81,0,0,0,1.28.23,2.63,2.63,0,0,1,1.78,1A7,7,0,0,1,8,15Z" />
    </symbol>
    <symbol id="collection" viewBox="0 0 16 16">
        <rect width="7" height="7" />
        <rect y="9" width="7" height="7" />
        <rect x="9" width="7" height="7" />
        <rect x="9" y="9" width="7" height="7" />
    </symbol>
    <symbol id="charts" viewBox="0 0 16 16">
        <polygon points="0.64 7.38 -0.02 6.63 2.55 4.38 4.57 5.93 9.25 0.78 12.97 4.37 15.37 2.31 16.02 3.07 12.94 5.72 9.29 2.21 4.69 7.29 2.59 5.67 0.64 7.38" />
        <rect y="9" width="2" height="7" />
        <rect x="12" y="8" width="2" height="8" />
        <rect x="8" y="6" width="2" height="10" />
        <rect x="4" y="11" width="2" height="5" />
    </symbol>
    <symbol id="comments" viewBox="0 0 16 16">
        <path d="M0,16.13V2H15V13H5.24ZM1,3V14.37L5,12h9V3Z" />
        <rect x="3" y="5" width="9" height="1" />
        <rect x="3" y="7" width="7" height="1" />
        <rect x="3" y="9" width="5" height="1" />
    </symbol>
    <symbol id="pages" viewBox="0 0 16 16">
        <rect x="4" width="12" height="12" transform="translate(20 12) rotate(-180)" />
        <polygon points="2 14 2 2 0 2 0 14 0 16 2 16 14 16 14 14 2 14" />
    </symbol>
    <symbol id="appearance" viewBox="0 0 16 16">
        <path d="M3,0V7A2,2,0,0,0,5,9H6v5a2,2,0,0,0,4,0V9h1a2,2,0,0,0,2-2V0Zm9,7a1,1,0,0,1-1,1H9v6a1,1,0,0,1-2,0V8H5A1,1,0,0,1,4,7V6h8ZM4,5V1H6V4H7V1H9V4h1V1h2V5Z" />
    </symbol>
    <symbol id="trends" viewBox="0 0 16 16">
        <polygon points="0.64 11.85 -0.02 11.1 2.55 8.85 4.57 10.4 9.25 5.25 12.97 8.84 15.37 6.79 16.02 7.54 12.94 10.2 9.29 6.68 4.69 11.76 2.59 10.14 0.64 11.85" />
    </symbol>
    <symbol id="settings" viewBox="0 0 16 16">
        <rect x="9.78" y="5.34" width="1" height="7.97" />
        <polygon points="7.79 6.07 10.28 1.75 12.77 6.07 7.79 6.07" />
        <rect x="4.16" y="1.75" width="1" height="7.97" />
        <polygon points="7.15 8.99 4.66 13.31 2.16 8.99 7.15 8.99" />
        <rect x="1.28" width="1" height="4.97" />
        <polygon points="3.28 4.53 1.78 7.13 0.28 4.53 3.28 4.53" />
        <rect x="12.84" y="11.03" width="1" height="4.97" />
        <polygon points="11.85 11.47 13.34 8.88 14.84 11.47 11.85 11.47" />
    </symbol>

    <symbol id="options" viewBox="0 0 16 16">
        <path d="M8,11a3,3,0,1,1,3-3A3,3,0,0,1,8,11ZM8,6a2,2,0,1,0,2,2A2,2,0,0,0,8,6Z" />
        <path d="M8.5,16h-1A1.5,1.5,0,0,1,6,14.5v-.85a5.91,5.91,0,0,1-.58-.24l-.6.6A1.54,1.54,0,0,1,2.7,14L2,13.3a1.5,1.5,0,0,1,0-2.12l.6-.6A5.91,5.91,0,0,1,2.35,10H1.5A1.5,1.5,0,0,1,0,8.5v-1A1.5,1.5,0,0,1,1.5,6h.85a5.91,5.91,0,0,1,.24-.58L2,4.82A1.5,1.5,0,0,1,2,2.7L2.7,2A1.54,1.54,0,0,1,4.82,2l.6.6A5.91,5.91,0,0,1,6,2.35V1.5A1.5,1.5,0,0,1,7.5,0h1A1.5,1.5,0,0,1,10,1.5v.85a5.91,5.91,0,0,1,.58.24l.6-.6A1.54,1.54,0,0,1,13.3,2L14,2.7a1.5,1.5,0,0,1,0,2.12l-.6.6a5.91,5.91,0,0,1,.24.58h.85A1.5,1.5,0,0,1,16,7.5v1A1.5,1.5,0,0,1,14.5,10h-.85a5.91,5.91,0,0,1-.24.58l.6.6a1.5,1.5,0,0,1,0,2.12L13.3,14a1.54,1.54,0,0,1-2.12,0l-.6-.6a5.91,5.91,0,0,1-.58.24v.85A1.5,1.5,0,0,1,8.5,16ZM5.23,12.18l.33.18a4.94,4.94,0,0,0,1.07.44l.36.1V14.5a.5.5,0,0,0,.5.5h1a.5.5,0,0,0,.5-.5V12.91l.36-.1a4.94,4.94,0,0,0,1.07-.44l.33-.18,1.12,1.12a.51.51,0,0,0,.71,0l.71-.71a.5.5,0,0,0,0-.71l-1.12-1.12.18-.33a4.94,4.94,0,0,0,.44-1.07l.1-.36H14.5a.5.5,0,0,0,.5-.5v-1a.5.5,0,0,0-.5-.5H12.91l-.1-.36a4.94,4.94,0,0,0-.44-1.07l-.18-.33L13.3,4.11a.5.5,0,0,0,0-.71L12.6,2.7a.51.51,0,0,0-.71,0L10.77,3.82l-.33-.18a4.94,4.94,0,0,0-1.07-.44L9,3.09V1.5A.5.5,0,0,0,8.5,1h-1a.5.5,0,0,0-.5.5V3.09l-.36.1a4.94,4.94,0,0,0-1.07.44l-.33.18L4.11,2.7a.51.51,0,0,0-.71,0L2.7,3.4a.5.5,0,0,0,0,.71L3.82,5.23l-.18.33a4.94,4.94,0,0,0-.44,1.07L3.09,7H1.5a.5.5,0,0,0-.5.5v1a.5.5,0,0,0,.5.5H3.09l.1.36a4.94,4.94,0,0,0,.44,1.07l.18.33L2.7,11.89a.5.5,0,0,0,0,.71l.71.71a.51.51,0,0,0,.71,0Z" />
    </symbol>
    <symbol id="collapse" viewBox="0 0 16 16">
        <polygon points="11.62 3.81 7.43 8 11.62 12.19 10.09 13.71 4.38 8 10.09 2.29 11.62 3.81" />
    </symbol>
    <symbol id="search" viewBox="0 0 16 16">
        <path d="M6.57,1A5.57,5.57,0,1,1,1,6.57,5.57,5.57,0,0,1,6.57,1m0-1a6.57,6.57,0,1,0,6.57,6.57A6.57,6.57,0,0,0,6.57,0Z" />
        <rect x="11.84" y="9.87" width="2" height="5.93" transform="translate(-5.32 12.84) rotate(-45)" />
    </symbol>
    </svg>
    <header class="page-header">
    <nav>
    <a href="<?= base_url('dashboard'); ?>" aria-label="forecastr logo" class="logo">
        <img src="<?php echo base_url('img/logo/logo.png'); ?>" alt="Logo" width="180" height="100">
        </a>
        <button class="toggle-mob-menu" aria-expanded="false" aria-label="open menu">
        <svg width="20" height="20" aria-hidden="true">
            <use xlink:href="#down"></use>
        </svg>
        </button>
        <ul class="admin-menu">
        <li class="menu-heading">
            <h3><?= session('Username') ?></h3>
        </li>
        <li class="<?= (current_url() == base_url('test')) ? 'active' : '' ?>">
        <a href="<?= base_url('test'); ?>">
        <svg>
                <use xlink:href="#pages"></use>
            </svg>
            <span>Exámenes</span>
            </a>
        </li>
        <li>
        <a href="<?= base_url('info'); ?>">
            <svg>
                <use xlink:href="#users"></use>
            </svg>
            <span>Mi información</span>
            </a>
        </li>
        <li>
        <a href="<?= base_url('recordedclasses'); ?>">
            <svg>
                <use xlink:href="#collection"></use>
            </svg>
            <span>Clases grabadas</span>
        </a>
        </li>
        <li>
    <a href="<?= base_url('materialeduc'); ?>">
        <svg>
            <use xlink:href="#pages"></use>
        </svg>
        <span>Material educativo</span>
    </a>
        </li>
        <li class="menu-heading">
            <h3>Ajustes</h3>
        </li>
        <li>
            <a href="<?= base_url('settings'); ?>">
                <svg>
                    <use xlink:href="#settings"></use>
                </svg>
                <span>Ajustes</span>
            </a>
        </li>
        <li>
    <a href="<?= base_url('tickets'); ?>">
        <svg>
            <use xlink:href="#comments"></use>
        </svg>
        <span>Tickets</span>
        </a>
    </li>
    <li>
        <li>
            <a href="<?= base_url('logout') ?>">
            <svg width="32" height="32">
            <use xlink:href="#users"></use>
            </svg>
            <span>Cerrar sesión</span>
            </a>
        </li>
        <li>
            <div class="switch">
            <input type="checkbox" id="mode" checked>
            <label for="mode">
                <span></span>
                <span>Noche</span>
            </label>
            </div>
            <button class="collapse-btn" aria-expanded="true" aria-label="collapse menu">
            <svg aria-hidden="true">
                <use xlink:href="#collapse"></use>
            </svg>
            <span>Contraer</span>
            </button>
        </li>
        </ul>
    </nav>
    </header>



    <?php if (session()->get('FK_Rol') == 1): ?>
<section class="page-content">
<div class="settings-section">
        <h2>Examen: <?= esc($testInfo['NameTest']); ?></h2>
        <p><strong>Duración:</strong> <?= esc($testInfo['DurationTime']); ?> minutos</p>
        <p><strong>Descripción:</strong> <?= esc($testInfo['Description']); ?></p>

        <!-- Formulario para enviar respuestas -->
        <form id="exam-form">
            <input type="hidden" name="FK_Test" value="<?= esc($testInfo['PK_Test']) ?>">
            <input type="hidden" name="PK_User" value="<?= esc(session()->get('PK_User')) ?>">

            <!-- Mostrar solo la pregunta actual -->
            <div id="question-container">
                <fieldset class="question-block">
                    <legend><strong>Pregunta <span id="question-number"></span>:</strong> <span id="question-text"></span></legend>

                    <!-- Instrucciones de la pregunta -->
                    <p><strong>Instrucciones:</strong> <span id="question-instructions"></span></p>

                    <!-- Mostrar la materia o tema -->
                    <p><strong>Materia:</strong> <span id="question-subject"></span></p>

                    <!-- Opciones de respuesta -->
                    <div class="form-group">
                        <label><strong>Opciones:</strong></label>
                        <div class="options-container" id="options-container">
                            <!-- Opciones de respuesta se llenarán dinámicamente -->
                        </div>
                    </div>
                </fieldset>
            </div>

        </form>
        <form id="typetext-form" style="display:none;">
            <input type="hidden" name="FK_Test" value="<?= esc($testInfo['PK_Test']) ?>">
            <input type="hidden" name="PK_User" value="<?= esc(session()->get('PK_User')) ?>">

            <!-- Mostrar la imagen relacionada con la pregunta -->
            <div class="form-group math-image-container">
            <label><strong>Imagen Relacionada:</strong></label>
                <img id="typetext-image" src="" alt="Imagen de la pregunta" style="max-width: 100%; height: auto; display: none;">
            </div>
            <!-- Mostrar solo la pregunta actual -->
            <div id="typetext-container">
                <fieldset class="typetext-block">
                    <legend><strong>Pregunta <span id="typetext-number"></span>:</strong> <span id="typetext-text"></span></legend>

                    <!-- Instrucciones de la pregunta -->
                    <p><strong>Instrucciones:</strong> <span id="typetext-instructions"></span></p>

                    <!-- Mostrar la materia o tema -->
                    <p><strong>Materia:</strong> <span id="typetext-subject"></span></p>

                    <!-- Opciones de respuesta -->
                    <div class="form-group">
                        <label><strong>Opciones:</strong></label>
                        <input type="text" id="Answer">
                    </div>
                </fieldset>
            </div>

        </form>

        <form id="timeline-form" style="display:none;">
            <input type="hidden" name="FK_Test" value="<?= esc($testInfo['PK_Test']) ?>">
            <input type="hidden" name="PK_User" value="<?= esc(session()->get('PK_User')) ?>">

            <!-- Mostrar la imagen relacionada con la pregunta -->
            <div class="form-group">
                <label><strong>Imagen Relacionada:</strong></label>
                <img id="timeline-image" src="" alt="Imagen de la pregunta" style="max-width: 100%; height: auto; display: none;">
            </div>
            <!-- Mostrar solo la pregunta actual -->
            <div id="timeline-container">
                <fieldset class="timeline-block">
                    <legend><strong>Pregunta <span id="timeline-number"></span>:</strong> <span id="timeline-text"></span></legend>

                    <!-- Instrucciones de la pregunta -->
                    <p><strong>Instrucciones:</strong> <span id="timeline-instructions"></span></p>

                    <!-- Mostrar la materia o tema -->
                    <p><strong>Materia:</strong> <span id="timeline-subject"></span></p>

                    <!-- Opciones de respuesta -->
                    <div class="form-group">
                        <label><strong>Opciones:</strong></label>
                        <div class="events-container" id="events-container" style="display: flex; justify-content: space-around;">
                            <!-- Opciones de respuesta se llenarán dinámicamente -->
                        </div>
                    </div>
                </fieldset>
            </div>

        </form>

        <!-- PREGUNTAS DE TIPO MATH  -->

        <form id="math-form" style="display:none;">
    <input type="hidden" name="FK_Test" value="<?= esc($testInfo['PK_Test']) ?>">
    <input type="hidden" name="PK_User" value="<?= esc(session()->get('PK_User')) ?>">

    <!-- Imagen de la pregunta -->
    <div class="form-group math-image-container">
        <label><strong>Imagen Relacionada:</strong></label>
        <img id="math-image" src="" alt="Imagen de la pregunta">
    </div>


    <!-- Contenedor de la pregunta actual -->
    <div id="math-container">
        <fieldset class="math-block question-block">
            <legend><strong>Pregunta <span id="math-number"></span>:  </strong><strong><span id="math-text"></span></strong></legend>

            <!-- Instrucciones -->
            <p><strong>Instrucciones:</strong> <span id="math-instructions"></span></p>

            <!-- Materia -->
            <p><strong>Materia:</strong> <span id="math-subject"></span></p>

            <!-- Opciones de respuesta -->
            <div class="form-group options-container">
                <label><strong>Opciones:</strong></label>
                <label class="option">
                    <input type="radio" name="Answer" id="Option1" value="Option1">
                    <span id="math-option1"></span>
                </label>
                <label class="option">
                    <input type="radio" name="Answer" id="Option2" value="Option2">
                    <span id="math-option2"></span>
                </label>
                <label class="option">
                    <input type="radio" name="Answer" id="Option3" value="Option3">
                    <span id="math-option3"></span>
                </label>
                <label class="option">
                    <input type="radio" name="Answer" id="Option4" value="Option4">
                    <span id="math-option4"></span>
                </label>
            </div>
        </fieldset>
    </div>
        </form>

        <form id="category-form" style="display: none;">
    <input type="hidden" name="FK_Test" value="<?= esc($testInfo['PK_Test']) ?>">
    <input type="hidden" name="PK_User" value="<?= esc(session()->get('PK_User')) ?>">

    <fieldset class="category-block question-block">
        <legend><strong>Preguntas de Categorías</strong></legend>

        <?php foreach ($categoryQuestions as $question): ?>
            <div class="question-section">
                <p><strong>Pregunta:</strong> <?= esc($question['Question']) ?></p>
                <p><strong>Instrucciones:</strong> <?= esc($question['Instructions']) ?></p>

                <!-- Verificar si PK_Question existe antes de añadirlo como campo oculto -->
                <?php if (isset($question['PK_Question'])): ?>
                    <input type="hidden" name="FK_Question" value="<?= esc($question['PK_Question']) ?>">
                <?php else: ?>
                    <p class="error">Pregunta sin ID asignado.</p>
                <?php endif; ?>

                <div class="categories-container">
                    <?php foreach ($question['Categories'] as $category): ?>
                        <div class="category-column">
                            <h4><?= esc($category['Category']) ?></h4>
                        </div>
                    <?php endforeach; ?>
                </div>

                <!-- Opciones para asignar ítems a categorías -->
                <div class="items-assign-section">
                    <h4>Asignar ítems</h4>
                    <p>Selecciona en qué categoría deseas poner cada ítem:</p>
                    <?php foreach ($question['Categories'] as $category): ?>
                        <?php if (!empty($category['Items'])): ?>
                            <?php foreach ($category['Items'] as $item): ?>
                                <div class="item-option">
                                    <label><?= esc($item) ?></label>
                                    <select name="item_category_<?= esc($item) ?>" class="item-select">
                                        <?php foreach ($question['Categories'] as $cat): ?>
                                            <option value="<?= esc($cat['Category']) ?>"><?= esc($cat['Category']) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>

                <hr>
            </div>
        <?php endforeach; ?>
        </fieldset>
    </form>

        <!-- Botón para cambiar a la siguiente pregunta -->
        <button id="next-question" class="btn btn-send">Siguiente Pregunta</button>

    <button onclick="openCalculator()" class="btn btn-send">Abrir Calculadora</button>

</section>


<?php endif; ?>


<!-- Modal de la Calculadora -->
<div id="calculatorModal" class="modal">
    <div class="modal-content">
        <span class="close" onclick="closeCalculator()">&times;</span>
        <h2>Calculadora</h2>
        <div class="calculator">
            <input type="text" id="calc-display" oninput="updateDisplay()" placeholder="0">
            <div class="calc-buttons">
                <button onclick="clearDisplay()">C</button>
                <button onclick="pressKey('/')">÷</button>
                <button onclick="pressKey('*')">×</button>
                <button onclick="pressKey('-')">−</button>

                <button onclick="pressKey('1')">1</button>
                <button onclick="pressKey('2')">2</button>
                <button onclick="pressKey('3')">3</button>

                <button onclick="pressKey('4')">4</button>
                <button onclick="pressKey('5')">5</button>
                <button onclick="pressKey('6')">6</button>

                <button onclick="pressKey('7')">7</button>
                <button onclick="pressKey('8')">8</button>
                <button onclick="pressKey('9')">9</button>
                <button onclick="pressKey('+')">+</button>

                <button onclick="calculate()">=</button>

                <button onclick="pressKey('0')" style="grid-column: span 2">0</button>
                <button onclick="pressKey('.')">.</button>
            </div>
        </div>
    </div>
</div>



</body>
</html>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
<script src="<?=base_url()?>js/dashboard/dashboard.js"></script>
<script src="<?=base_url()?>js/Calculator/calculator.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/js/bootstrap-select.min.js"></script>

<script>
    var baseUrl = "<?= base_url() ?>";
    var userId = "<?= session()->get('PK_User') ?>"; 
</script>



<script>
let currentQuestionIndex = 0;
const questions = <?= json_encode($grammarQuestions) ?>;
let selectedAnswer = null; // Variable para almacenar la respuesta seleccionada
var contador = 0;

// Función para mostrar la pregunta actual
function loadQuestion(index) {
    const question = questions[index];  
    
    document.getElementById('question-number').innerText = index + 1;
    document.getElementById('question-text').innerText = question.Question;
    document.getElementById('question-instructions').innerText = question.Instructions;
    document.getElementById('question-subject').innerText = question.Subject;

    const optionsContainer = document.getElementById('options-container');
    optionsContainer.innerHTML = '';  

    // Agregar opciones de respuesta
    ['Option1', 'Option2', 'Option3', 'Option4'].forEach(option => {
        if (question[option]) {
            const label = document.createElement('label');
            label.classList.add('option');
            label.innerHTML = `
                <input type="radio" name="answer_${question.PK_Question}" value="${question[option]}" onchange="selectAnswer('${question[option]}')"> 
                <span>${question[option]}</span>
            `;
            optionsContainer.appendChild(label);
        }
    });
    document.getElementById('grammarNextType').style.display = index < questions.length - 1 ? 'none' : 'block';
}

// Función para almacenar la respuesta seleccionada
function selectAnswer(answer) {
    selectedAnswer = answer;  // Guardar la respuesta seleccionada
}

// Función para enviar la respuesta al servidor
function submitAnswer() {
    if (!selectedAnswer) {
        console.error('No hay respuesta seleccionada');
        return;
    }

    const formData = new FormData();
    formData.append('FK_Test', <?= esc($testInfo['PK_Test']) ?>);
    formData.append('PK_User', <?= esc(session()->get('PK_User')) ?>);
    formData.append('FK_Question', questions[currentQuestionIndex].PK_Question);
    formData.append('Answer', selectedAnswer);

    fetch('<?= site_url('test/submitAnswer') ?>', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            console.log('Respuesta enviada correctamente');
            selectedAnswer = null;  // Resetear la respuesta seleccionada
            contador++;
            console.log(contador);
            if(contador == questions.length){
                document.getElementById('exam-form').style.display = 'none';  // Ocultar el formulario actual
                document.getElementById('typetext-form').style.display = 'block';  // Mostrar el siguiente formulario
            }
        } else {
            console.error('Error al enviar la respuesta', data.error);
        }
    })
    .catch(error => console.error('Error en el envío', error));
}

// Cargar la primera pregunta
loadQuestion(currentQuestionIndex);
</script>

<!---------------------------------------------- Type Text Questions  ---------------------------------------------------------------------------->

<script>
let currentTypeTextIndex = 0;
const typetextQuestions = <?= json_encode($typetextQuestions) ?>;
let typeTextAnswer = null; // Variable para almacenar la respuesta seleccionada
var typetextcontador = 0;

function changeForm(){
    document.getElementById('exam-form').style.display = 'none';  // Ocultar el formulario actual
    document.getElementById('typetext-form').style.display = 'block';  // Mostrar el siguiente formulario
}
// Función para mostrar la pregunta actual con la ruta correcta
function loadTypeTextQuestion(index) {
    const testQuestion = typetextQuestions[index];

    document.getElementById('typetext-number').innerText = index + 1;
    document.getElementById('typetext-text').innerText = testQuestion.Question;
    document.getElementById('typetext-instructions').innerText = testQuestion.Instructions;
    document.getElementById('typetext-subject').innerText = testQuestion.Subject;
    
    // Cargar la imagen si existe
    const imagePath = testQuestion.UploadMaterial;  // Asumiendo que el campo se llama UploadMaterial
    const imageElement = document.getElementById('typetext-image');

    if (imagePath) {
        // Construir la ruta correcta sin duplicar "Uploads"
        imageElement.src = "<?= base_url() ?>" + "/" + imagePath;
        imageElement.style.display = 'block';  // Mostrar la imagen
    } else {
        imageElement.style.display = 'none';  // Ocultar si no hay imagen
    }
}

// Función para enviar la respuesta al servidor
function submitTypeText() {
    const typeTextAnswer = document.getElementById('Answer').value;
    if (!typeTextAnswer) {
        console.error('No hay respuesta seleccionada');
        return;
    }

    console.log('Respuesta ingresada:', typeTextAnswer);  // Depurar el valor
    console.log(typetextQuestions[currentTypeTextIndex].PK_Question);
    const formData = new FormData();
    formData.append('FK_Test', <?= esc($testInfo['PK_Test']) ?>);
    formData.append('PK_User', <?= esc(session()->get('PK_User')) ?>);
    formData.append('FK_Question', typetextQuestions[currentTypeTextIndex].PK_Question);
    formData.append('Answer', typeTextAnswer);
    fetch('<?= site_url('typetext/submitAnswer') ?>', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            console.log('Respuesta enviada correctamente');
            document.getElementById('Answer').value = ''; // Limpiar el campo después de enviar
            typetextcontador++;
            if(typetextcontador == typetextQuestions.length){
                document.getElementById('typetext-form').style.display = 'none';  // Ocultar el formulario actual
                document.getElementById('timeline-form').style.display = 'block';  // Mostrar el siguiente formulario
            }
        } else {
            console.error('Error al enviar la respuesta', data.error);
        }
    })
    .catch(error => console.error('Error en el envío', error));
}

// Cargar la primera pregunta
loadTypeTextQuestion(currentTypeTextIndex);

// Botón de siguiente pregunta
document.getElementById('next-question').addEventListener('click', function() {
    if (document.getElementById('exam-form').style.display !== 'none') {
        // Si el formulario de gramática está visible, enviar la respuesta de gramática
        submitAnswer();
        currentQuestionIndex++;
        loadQuestion(currentQuestionIndex);  // Cargar la siguiente pregunta
    } else if (document.getElementById('typetext-form').style.display !== 'none') {
        // Si el formulario de tipo texto está visible, enviar la respuesta de tipo texto
        submitTypeText();
        currentTypeTextIndex++;
        loadTypeTextQuestion(currentTypeTextIndex);  // Cargar la siguiente pregunta
    }
});
</script>

<!---------------------------------------------- TimeLine Questions ---------------------------------------------------------------------------->

<script>
let currentTimelimeIndex = 0;
const TimelineQuestions = <?= json_encode($timelineQuestions) ?>;
let timelineAnswer = null; // Variable para almacenar la respuesta seleccionada
var timelinecontador = 0;

function changeForm(){
    document.getElementById('typetext-form').style.display = 'none';  // Ocultar el formulario actual
    document.getElementById('timeline-form').style.display = 'block';  // Mostrar el siguiente formulario
}
// Función para mostrar la pregunta actual con la ruta correcta
function loadTimelineQuestion(index) {
    const timelineQuestion = TimelineQuestions[index];

    document.getElementById('timeline-number').innerText = index + 1;
    document.getElementById('timeline-text').innerText = timelineQuestion.Question;
    document.getElementById('timeline-instructions').innerText = timelineQuestion.Instructions;
    document.getElementById('timeline-subject').innerText = timelineQuestion.Subject;

    // Cargar la imagen si existe
    const imagePath = timelineQuestion.UploadMaterial;  // Asumiendo que el campo se llama UploadMaterial
    const imageElement = document.getElementById('timeline-image');

    if (imagePath) {
        // Construir la ruta correcta sin duplicar "Uploads"
        imageElement.src = "<?= base_url() ?>" + "/" + imagePath;
        imageElement.style.display = 'block';  // Mostrar la imagen
    } else {
        imageElement.style.display = 'none';  // Ocultar si no hay imagen
    }

    // Procesar Event_Descriptions y mostrarlo en divs
    const eventDescriptions = timelineQuestion.Event_Descriptions; // Asegúrate de que este campo exista en el objeto
    const eventsContainer = document.getElementById('events-container');
    const FK_Events = timelineQuestion.PK_Timeline_Events;
    eventsContainer.innerHTML = ''; // Limpiar contenido previo

    if (eventDescriptions && FK_Events) {
        const events = eventDescriptions.split(','); // Dividir por comas
        const fks = FK_Events.split(','); // Dividir FK_Events por comas

        // Asegúrate de que la longitud de ambos arrays coincida
        if (events.length === fks.length) {
            events.forEach((event, index) => {
                const div = document.createElement('div');

                // Crear un elemento span para mostrar el número del div
                const numberSpan = document.createElement('span');
                numberSpan.textContent = index + 1; // Comenzar la numeración desde 1
                div.appendChild(numberSpan); // Añadir el span al div

                const select = document.createElement('select');

                // Añadir un option para cada evento al select
                events.forEach((event, i) => {
                    const option = document.createElement('option');
                    option.value = fks[i].trim(); // Usar el valor del fk correspondiente
                    option.textContent = event.trim(); // Mostrar el evento como texto
                    select.appendChild(option); // Añadir el option al select
                });

                div.appendChild(select); // Añadir el select al div
                eventsContainer.appendChild(div); // Añadir el div al contenedor de eventos
            });
        } else {
            console.error("La cantidad de eventos y FK_Events no coincide.");
        }
    }

}

// Función para enviar la respuesta al servidor
function submitTimeline() {
    console.log('timeline entra');
    // Obtener todos los selects dentro del contenedor de eventos
    const eventSelects = document.querySelectorAll('#events-container select');
    console.log('Número de selects encontrados:', eventSelects.length);

    if (eventSelects.length === 0) {
        console.warn('No se encontraron selects dentro de #eventsContainer');
        return;
    }

    const userPK = <?= esc(session()->get('PK_User')) ?>; // Obtiene el PK_User de la sesión
    const questionPK = TimelineQuestions[currentTimelimeIndex].PK_Question; // Obtener el PK_Question
    

    // Iterar sobre cada select
    eventSelects.forEach((select, index) => {
        console.log('timeline foreach');
        const fkEvent = select.value; // Obtener el value del select (FK_Event)
        const answer = index + 1; // El número del div (index + 1)

        const formData = new FormData();
        formData.append('FK_Event', fkEvent);
        formData.append('PK_User', userPK);
        formData.append('FK_Question', questionPK);
        formData.append('Answer', answer); // El número del div como respuesta

        // Enviar cada formulario de datos
        fetch('<?= site_url('timeline/submitAnswer') ?>', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                console.log('Respuesta enviada correctamente para el evento:', fkEvent);
                document.getElementById('Answer').value = ''; // Limpiar el campo después de enviar
                
                if (timelinecontador === TimelineQuestions.length) {
                    document.getElementById('timeline-form').style.display = 'none';  // Ocultar el formulario actual
                    document.getElementById('math-form').style.display = 'block';  // Ocultar el formulario actual
                }
            } else {
                console.error('Error al enviar la respuesta para el evento:', fkEvent, data.error);
            }
        })
        .catch(error => console.error('Error en el envío', error));
    });
}


// Cargar la primera pregunta
loadTimelineQuestion(currentTimelimeIndex);

// Botón de siguiente pregunta
document.getElementById('next-question').addEventListener('click', function() {
    if (document.getElementById('timeline-form').style.display !== 'none') {
        // Si el formulario de gramática está visible, enviar la respuesta de gramática
        submitTimeline();
        timelinecontador++;
        currentTimelimeIndex++;
        loadTimelineQuestion(currentTimelimeIndex);  // Cargar la siguiente pregunta
    }
});
</script>

<!---------------------------------------------- Type Math Test  ---------------------------------------------------------------------------->

<script>
// Inicializar el índice y el contador de matemáticas
let currentMathIndex = 0;
const mathQuestions = <?= json_encode($mathQuestions) ?>;
let mathCounter = 0;

// Función para cargar la pregunta matemática actual sin conflicto con otras funciones
function loadMathQuestion(index) {
    if (index < mathQuestions.length) {
        const mathQuestion = mathQuestions[index];

        // Rellenar campos en el formulario
        document.getElementById('math-number').innerText = index + 1;
        document.getElementById('math-text').innerText = mathQuestion.Question || '';
        document.getElementById('math-instructions').innerText = mathQuestion.Instructions || '';
        document.getElementById('math-subject').innerText = mathQuestion.Subject || '';

        // Rellenar las opciones de respuesta si existen
        document.getElementById('math-option1').innerText = mathQuestion.Option1 || '';
        document.getElementById('math-option2').innerText = mathQuestion.Option2 || '';
        document.getElementById('math-option3').innerText = mathQuestion.Option3 || '';
        document.getElementById('math-option4').innerText = mathQuestion.Option4 || '';

        // Cargar la imagen si existe
        const mathImagePath = mathQuestion.UploadMaterial;
        const mathImageElement = document.getElementById('math-image');

        if (mathImagePath) {
            mathImageElement.src = "<?= base_url() ?>" + "/" + mathImagePath;
            mathImageElement.style.display = 'block';
        } else {
            mathImageElement.style.display = 'none';
        }
    }
}

// Función para enviar la respuesta matemática al servidor sin interferir con otros formularios
function submitMathAnswer() {
    const selectedAnswer = document.querySelector('input[name="Answer"]:checked');
    if (!selectedAnswer) {
        console.error('No hay respuesta seleccionada');
        alert('Por favor selecciona una respuesta antes de continuar.');
        return;
    }
    
    const mathAnswer = selectedAnswer.value;
    console.log('Respuesta ingresada:', mathAnswer);

    const formData = new FormData();
    formData.append('FK_Test', <?= esc($testInfo['PK_Test']) ?>);
    formData.append('PK_User', <?= esc(session()->get('PK_User')) ?>);
    formData.append('FK_Question', mathQuestions[currentMathIndex].PK_Question);
    formData.append('Answer', mathAnswer);

    fetch('<?= site_url('math/submitAnswer') ?>', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            console.log('Respuesta enviada correctamente');
            document.querySelector('input[name="Answer"]:checked').checked = false; // Desmarcar respuesta
            mathCounter++;
            if (mathCounter === mathQuestions.length) {
                document.getElementById('math-form').style.display = 'none';  // Ocultar el formulario actual
                document.getElementById('category-form').style.display = 'block';  // Ocultar el formulario actual
            } else {
                currentMathIndex++;
                loadMathQuestion(currentMathIndex);  // Cargar la siguiente pregunta matemática
            }
        } else {
            console.error('Error al enviar la respuesta', data.error);
        }
    })
    .catch(error => console.error('Error en el envío', error));
}

// Evento para el botón de siguiente pregunta, detectando si el formulario de matemáticas está activo
document.getElementById('next-question').addEventListener('click', function() {
    // Detectar si el formulario de matemáticas está visible
    if (document.getElementById('math-form').style.display !== 'none') {
        submitMathAnswer();  // Enviar respuesta de matemáticas y cargar la siguiente pregunta
    } else {
        console.log("Otro formulario activo, manejando en consecuencia.");
    }
});

// Cargar la primera pregunta matemática al iniciar
loadMathQuestion(currentMathIndex);

</script>


<!-- FORMULARIO DE CATEGORIAS -->
<script>
let currentCategoryIndex = 0;
const categoryQuestions = <?= json_encode($categoryQuestions) ?>;

// Función para cargar solo una pregunta a la vez
function loadCategoryQuestion(index) {
    if (index < categoryQuestions.length) {
        const categoryQuestion = categoryQuestions[index];

        // Verificar que la pregunta tenga PK_Question
        if (!categoryQuestion || !categoryQuestion.PK_Question) {
            console.warn(`La pregunta en el índice ${index} no tiene PK_Question definido.`);
            return;
        }

        // Mostrar información de la pregunta
        document.getElementById('category-text').innerText = categoryQuestion.Question || '';
        document.getElementById('category-instructions').innerText = categoryQuestion.Instructions || '';

        // Cargar categorías
        const categoryOptionsContainer = document.getElementById('category-options');
        categoryOptionsContainer.innerHTML = ''; // Limpiar opciones anteriores

        categoryQuestion.Categories.forEach((category) => {
            const categoryDiv = document.createElement('div');
            categoryDiv.classList.add('category-column');
            categoryDiv.innerText = category.Category;
            categoryOptionsContainer.appendChild(categoryDiv);
        });

        // Cargar ítems para asignar a categorías
        const itemAssignContainer = document.getElementById('items-assign-section');
        itemAssignContainer.innerHTML = ''; // Limpiar ítems anteriores

        categoryQuestion.Categories[0].Items.forEach((item) => {
            const itemDiv = document.createElement('div');
            itemDiv.classList.add('item-option');
            
            const itemLabel = document.createElement('label');
            itemLabel.innerText = item;
            itemDiv.appendChild(itemLabel);

            const itemSelect = document.createElement('select');
            itemSelect.name = `item_category_${item}`;
            itemSelect.classList.add('item-select');

            categoryQuestion.Categories.forEach((category) => {
                const option = document.createElement('option');
                option.value = category.Category;
                option.innerText = category.Category;
                itemSelect.appendChild(option);
            });

            itemDiv.appendChild(itemSelect);
            itemAssignContainer.appendChild(itemDiv);
        });
    } else {
        // Ocultar el formulario si no hay más preguntas
        document.getElementById('category-form').style.display = 'none';
    }
}

// Enviar respuesta y cargar la siguiente pregunta
function submitCategoryAnswer() {
    const categoryQuestion = categoryQuestions[currentCategoryIndex];

    if (!categoryQuestion || !categoryQuestion.PK_Question) {
        console.error('La pregunta actual no tiene un PK_Question definido.');
        return;
    }

    const formData = new FormData();
    formData.append('FK_Test', <?= esc($testInfo['PK_Test']) ?>);
    formData.append('PK_User', <?= esc(session()->get('PK_User')) ?>);
    formData.append('FK_Question', categoryQuestion.PK_Question);

    let allAnswered = true;

    // Recorrer los ítems y categorías seleccionadas
    document.querySelectorAll('.item-option').forEach((itemOption, index) => {
        const itemLabel = itemOption.querySelector('label').innerText;
        const itemSelect = itemOption.querySelector('select');
        const selectedCategory = itemSelect.value;

        if (!selectedCategory) {
            allAnswered = false;
            console.error(`No se seleccionó una categoría para el ítem: ${itemLabel}`);
        }

        formData.append(`FK_Category_${index}`, selectedCategory);
        formData.append(`FK_Item_${index}`, itemLabel);
    });

    if (!allAnswered) {
        alert('Por favor, selecciona una categoría para cada ítem antes de continuar.');
        return;
    }

    fetch('<?= site_url('categories/submitAnswer') ?>', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            currentCategoryIndex++;
            loadCategoryQuestion(currentCategoryIndex); // Cargar siguiente pregunta
        } else {
            console.error('Error al enviar la respuesta', data.error);
        }
    })
    .catch(error => console.error('Error en el envío', error));
}

// Evento para el botón de siguiente pregunta
document.getElementById('next-question').addEventListener('click', submitCategoryAnswer);

// Cargar la primera pregunta de categorías
loadCategoryQuestion(currentCategoryIndex);

</script>


<script>
        document.addEventListener('DOMContentLoaded', function () {
            <?php if (session()->getFlashdata('success')): ?>
                Swal.fire({
                    title: 'Exito!!',
                    text: '<?= session()->getFlashdata('success') ?>',
                    icon: 'success',
                    confirmButtonText: 'OK'
                });
            <?php endif; ?>

            <?php if (session()->getFlashdata('error')): ?>
                Swal.fire({
                    title: 'Error!',
                    text: '<?= session()->getFlashdata('error') ?>',
                    icon: 'error',
                    confirmButtonText: 'OK'
                });
            <?php endif; ?>
            <?php if (session()->getFlashdata('info')): ?>
                Swal.fire({
                    title: 'Error!',
                    text: '<?= session()->getFlashdata('info') ?>',
                    icon: 'info',
                    confirmButtonText: 'OK'
                });
            <?php endif; ?>
        });
    </script>

