<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EDUMED</title>
    <link rel="stylesheet" href="<?php echo base_url('css/dashboard.css')?>">
    <link rel="stylesheet" href="<?php echo base_url('css/test/test.css')?>">
    <link rel="icon" type="image/png" href="<?php echo base_url('img/icon/icon.png')?>">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.dataTables.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    
    
</head>

<body>
    <svg style="display:none;">
    <symbol id="down" viewBox="0 0 16 16">
        <polygon points="3.81 4.38 8 8.57 12.19 4.38 13.71 5.91 8 11.62 2.29 5.91 3.81 4.38" />
    </symbol>
    <symbol id="users" viewBox="0 0 16 16">
        <path d="M8,0a8,8,0,1,0,8,8A8,8,0,0,0,8,0ZM8,15a7,7,0,0,1-5.19-2.32,2.71,2.71,0,0,1,1.7-1,13.11,13.11,0,0,0,1.29-.28,2.32,2.32,0,0,0,.94-.34,1.17,1.17,0,0,0-.27-.7h0A3.61,3.61,0,0,1,5.15,7.49,3.18,3.18,0,0,1,8,4.07a3.18,3.18,0,0,1,2.86,3.42,3.6,3.6,0,0,1-1.32,2.88h0a1.13,1.13,0,0,0-.27.69,2.68,2.68,0,0,0,.93.31,10.81,10.81,0,0,0,1.28.23,2.63,2.63,0,0,1,1.78,1A7,7,0,0,1,8,15Z" />
    </symbol>
    <symbol id="collection" viewBox="0 0 16 16">
        <rect width="7" height="7" />
        <rect y="9" width="7" height="7" />
        <rect x="9" width="7" height="7" />
        <rect x="9" y="9" width="7" height="7" />
    </symbol>
    <symbol id="charts" viewBox="0 0 16 16">
        <polygon points="0.64 7.38 -0.02 6.63 2.55 4.38 4.57 5.93 9.25 0.78 12.97 4.37 15.37 2.31 16.02 3.07 12.94 5.72 9.29 2.21 4.69 7.29 2.59 5.67 0.64 7.38" />
        <rect y="9" width="2" height="7" />
        <rect x="12" y="8" width="2" height="8" />
        <rect x="8" y="6" width="2" height="10" />
        <rect x="4" y="11" width="2" height="5" />
    </symbol>
    <symbol id="comments" viewBox="0 0 16 16">
        <path d="M0,16.13V2H15V13H5.24ZM1,3V14.37L5,12h9V3Z" />
        <rect x="3" y="5" width="9" height="1" />
        <rect x="3" y="7" width="7" height="1" />
        <rect x="3" y="9" width="5" height="1" />
    </symbol>
    <symbol id="pages" viewBox="0 0 16 16">
        <rect x="4" width="12" height="12" transform="translate(20 12) rotate(-180)" />
        <polygon points="2 14 2 2 0 2 0 14 0 16 2 16 14 16 14 14 2 14" />
    </symbol>
    <symbol id="appearance" viewBox="0 0 16 16">
        <path d="M3,0V7A2,2,0,0,0,5,9H6v5a2,2,0,0,0,4,0V9h1a2,2,0,0,0,2-2V0Zm9,7a1,1,0,0,1-1,1H9v6a1,1,0,0,1-2,0V8H5A1,1,0,0,1,4,7V6h8ZM4,5V1H6V4H7V1H9V4h1V1h2V5Z" />
    </symbol>
    <symbol id="trends" viewBox="0 0 16 16">
        <polygon points="0.64 11.85 -0.02 11.1 2.55 8.85 4.57 10.4 9.25 5.25 12.97 8.84 15.37 6.79 16.02 7.54 12.94 10.2 9.29 6.68 4.69 11.76 2.59 10.14 0.64 11.85" />
    </symbol>
    <symbol id="settings" viewBox="0 0 16 16">
        <rect x="9.78" y="5.34" width="1" height="7.97" />
        <polygon points="7.79 6.07 10.28 1.75 12.77 6.07 7.79 6.07" />
        <rect x="4.16" y="1.75" width="1" height="7.97" />
        <polygon points="7.15 8.99 4.66 13.31 2.16 8.99 7.15 8.99" />
        <rect x="1.28" width="1" height="4.97" />
        <polygon points="3.28 4.53 1.78 7.13 0.28 4.53 3.28 4.53" />
        <rect x="12.84" y="11.03" width="1" height="4.97" />
        <polygon points="11.85 11.47 13.34 8.88 14.84 11.47 11.85 11.47" />
    </symbol>

    <symbol id="options" viewBox="0 0 16 16">
        <path d="M8,11a3,3,0,1,1,3-3A3,3,0,0,1,8,11ZM8,6a2,2,0,1,0,2,2A2,2,0,0,0,8,6Z" />
        <path d="M8.5,16h-1A1.5,1.5,0,0,1,6,14.5v-.85a5.91,5.91,0,0,1-.58-.24l-.6.6A1.54,1.54,0,0,1,2.7,14L2,13.3a1.5,1.5,0,0,1,0-2.12l.6-.6A5.91,5.91,0,0,1,2.35,10H1.5A1.5,1.5,0,0,1,0,8.5v-1A1.5,1.5,0,0,1,1.5,6h.85a5.91,5.91,0,0,1,.24-.58L2,4.82A1.5,1.5,0,0,1,2,2.7L2.7,2A1.54,1.54,0,0,1,4.82,2l.6.6A5.91,5.91,0,0,1,6,2.35V1.5A1.5,1.5,0,0,1,7.5,0h1A1.5,1.5,0,0,1,10,1.5v.85a5.91,5.91,0,0,1,.58.24l.6-.6A1.54,1.54,0,0,1,13.3,2L14,2.7a1.5,1.5,0,0,1,0,2.12l-.6.6a5.91,5.91,0,0,1,.24.58h.85A1.5,1.5,0,0,1,16,7.5v1A1.5,1.5,0,0,1,14.5,10h-.85a5.91,5.91,0,0,1-.24.58l.6.6a1.5,1.5,0,0,1,0,2.12L13.3,14a1.54,1.54,0,0,1-2.12,0l-.6-.6a5.91,5.91,0,0,1-.58.24v.85A1.5,1.5,0,0,1,8.5,16ZM5.23,12.18l.33.18a4.94,4.94,0,0,0,1.07.44l.36.1V14.5a.5.5,0,0,0,.5.5h1a.5.5,0,0,0,.5-.5V12.91l.36-.1a4.94,4.94,0,0,0,1.07-.44l.33-.18,1.12,1.12a.51.51,0,0,0,.71,0l.71-.71a.5.5,0,0,0,0-.71l-1.12-1.12.18-.33a4.94,4.94,0,0,0,.44-1.07l.1-.36H14.5a.5.5,0,0,0,.5-.5v-1a.5.5,0,0,0-.5-.5H12.91l-.1-.36a4.94,4.94,0,0,0-.44-1.07l-.18-.33L13.3,4.11a.5.5,0,0,0,0-.71L12.6,2.7a.51.51,0,0,0-.71,0L10.77,3.82l-.33-.18a4.94,4.94,0,0,0-1.07-.44L9,3.09V1.5A.5.5,0,0,0,8.5,1h-1a.5.5,0,0,0-.5.5V3.09l-.36.1a4.94,4.94,0,0,0-1.07.44l-.33.18L4.11,2.7a.51.51,0,0,0-.71,0L2.7,3.4a.5.5,0,0,0,0,.71L3.82,5.23l-.18.33a4.94,4.94,0,0,0-.44,1.07L3.09,7H1.5a.5.5,0,0,0-.5.5v1a.5.5,0,0,0,.5.5H3.09l.1.36a4.94,4.94,0,0,0,.44,1.07l.18.33L2.7,11.89a.5.5,0,0,0,0,.71l.71.71a.51.51,0,0,0,.71,0Z" />
    </symbol>
    <symbol id="collapse" viewBox="0 0 16 16">
        <polygon points="11.62 3.81 7.43 8 11.62 12.19 10.09 13.71 4.38 8 10.09 2.29 11.62 3.81" />
    </symbol>
    <symbol id="search" viewBox="0 0 16 16">
        <path d="M6.57,1A5.57,5.57,0,1,1,1,6.57,5.57,5.57,0,0,1,6.57,1m0-1a6.57,6.57,0,1,0,6.57,6.57A6.57,6.57,0,0,0,6.57,0Z" />
        <rect x="11.84" y="9.87" width="2" height="5.93" transform="translate(-5.32 12.84) rotate(-45)" />
    </symbol>
    </svg>
    <header class="page-header">
    <nav>
    <a href="<?= base_url('dashboard'); ?>" aria-label="forecastr logo" class="logo">
        <img src="<?php echo base_url('img/logo/logo.png'); ?>" alt="Logo" width="180" height="100">
        </a>
        <button class="toggle-mob-menu" aria-expanded="false" aria-label="open menu">
        <svg width="20" height="20" aria-hidden="true">
            <use xlink:href="#down"></use>
        </svg>
        </button>
        <ul class="admin-menu">
        <li class="menu-heading">
            <h3><?= session('Username') ?></h3>
        </li>
        <li class="<?= (current_url() == base_url('test')) ? 'active' : '' ?>">
        <a href="<?= base_url('test'); ?>">
        <svg>
                <use xlink:href="#pages"></use>
            </svg>
            <span>Exámenes</span>
            </a>
        </li>
        <li>
        <a href="<?= base_url('info'); ?>">
            <svg>
                <use xlink:href="#users"></use>
            </svg>
            <span>Mi información</span>
            </a>
        </li>
        <li>
        <a href="<?= base_url('recordedclasses'); ?>">
            <svg>
                <use xlink:href="#collection"></use>
            </svg>
            <span>Clases grabadas</span>
        </a>
        </li>
        <li>
    <a href="<?= base_url('materialeduc'); ?>">
        <svg>
            <use xlink:href="#pages"></use>
        </svg>
        <span>Material educativo</span>
    </a>
        </li>
        <li class="menu-heading">
            <h3>Ajustes</h3>
        </li>
        <li>
            <a href="<?= base_url('settings'); ?>">
                <svg>
                    <use xlink:href="#settings"></use>
                </svg>
                <span>Ajustes</span>
            </a>
        </li>
        <li>
    <a href="<?= base_url('tickets'); ?>">
        <svg>
            <use xlink:href="#comments"></use>
        </svg>
        <span>Tickets</span>
        </a>
    </li>
    <li>
        <li>
            <a href="<?= base_url('logout') ?>">
            <svg width="32" height="32">
            <use xlink:href="#users"></use>
            </svg>
            <span>Cerrar sesión</span>
            </a>
        </li>
        <li>
            <div class="switch">
            <input type="checkbox" id="mode" checked>
            <label for="mode">
                <span></span>
                <span>Noche</span>
            </label>
            </div>
            <button class="collapse-btn" aria-expanded="true" aria-label="collapse menu">
            <svg aria-hidden="true">
                <use xlink:href="#collapse"></use>
            </svg>
            <span>Contraer</span>
            </button>
        </li>
        </ul>
    </nav>
    </header>

<?php if (session()->get('FK_Rol') == 2 || session()->get('FK_Rol') == 3): ?>
    <section class="page-content">

    <section class="dashboard">
        
    <div class="row">
        <!-- Crear Examen -->
        <div class="settings-section">
            <h2>Nuevo Examen</h2>
            <form method="post" action="<?php echo site_url('/test/createTest'); ?>" id="createExamen">
                <div class="form-group">
                    <label for="Name">Nombre:</label>
                    <input type="text" id="Name" name="Name" placeholder="Examen 1" required>
                </div>
                <div class="form-group">
                    <label for="Description">Descripción:</label>
                    <input type="text" id="Description" name="Description" placeholder="Simulación Excoba Medicina UAQ" required>
                </div>
                <div class="form-group ">
                    <label for="Duration">Duración:</label>
                        <div class="custom-select">
                        <select id="Duration" name="Duration">
                            <option value="60">1 hora</option>
                            <option value="90">1 hora y media</option>
                            <option value="120">2 horas</option>
                            <option value="180">3 horas</option>
                        </select>
                    </div>
                </div>
                <input type="hidden" id="userId" value="<?= session()->get('PK_User'); ?>">
                <button type="submit">Crear examen</button>
            </form>
        </div>
       
</div>


    </div>

        
        <!-- Historial de actividad -->
        <div class="settings-section">
                <h2>Examenes Creados</h2>
                <p>Examenes que has creado en la plataforma.</p>
                <div class="table-responsive">
                    <table id="groupsTable" class="display">
                        <thead>
                            <tr>
                                <th>Nombre del Examen</th>
                                <th>Grupo Asignado</th>
                                <th>Fecha de Creación</th>
                                <th>Status</th>
                                <th>Preguntas</th>
                                <th>Duración</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php if (!empty($assignedTests)): ?>
                            <?php foreach ($assignedTests as $exam): ?>
                                    <tr>
                                        <td><?= esc($exam['NameTest']); ?></td>
                                        <td><?= esc($exam['GroupName']); ?></td>
                                        <td><?= esc(date('d/m/Y', strtotime($exam['CreatedAt']))); ?></td>
                                        <td><?= esc($exam['Status']); ?></td>
                                        <td><?= esc($exam['StatusQuestions']); ?></td>
                                        <td><?= esc($exam['DurationTime']); ?> minutos</td>
                                        <td>
                                            <div class="row">
                                                <form method="post" action="<?php echo site_url('/test/updateTestStatus'); ?>" id="deactivateUserForm">
                                                    <input type="hidden" name="testId" id="testId" value="<?= $exam['PK_Test'] ?>">
                                                    <button type="submit" class="edit-button" title="Cambiar Status">
                                                    <i class="fa fa-check" aria-hidden="true"></i>
                                                    </button>
                                                </form>
                                                <button type="button" class="edit-button" title="Asignar gruoo" onclick="editData(<?= $exam['PK_Test'] ?>)">
                                                    <i class="fa fa-users" aria-hidden="true"></i>
                                                </button>
                                                <form method="post" action="<?= base_url('questions/assign') ?>" onsubmit="console.log('Formulario enviado')">
                                                    <input type="hidden" name="testId" value="<?= $exam['PK_Test'] ?>">
                                                    <button type="button" class="edit-button" title="Asignar preguntas" onclick="assignQuestions('<?= $exam['PK_Test'] ?>')">
    <i class="fa-solid fa-question" aria-hidden="true"></i>
</button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="2">No se han creado grupos recientemente.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

    </div>
</section>

    </section>
<?php endif; ?>

<?php if (session()->get('FK_Rol') == 1): ?>
    <section class="page-content">
    <div class="settings-section">
    <h2>Exámenes Creados</h2>
    <p>Exámenes que has creado en la plataforma.</p>
    <div class="table-responsive">
        <table id="testsStudentsTable" class="display">
            <thead>
                <tr>
                    <th>Nombre del Examen</th>
                    <th>Grupo Asignado</th>
                    <th>Fecha de Creación</th>
                    <th>Status</th>
                    <th>Status de Preguntas</th>
                    <th>Duración</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                        <?php if (!empty($assignedTests)): ?>
                <?php foreach ($assignedTests as $exam): ?>
                    <tr>
                        <td><?= esc($exam['NameTest']); ?></td>
                        <td><?= esc($exam['GroupName']); ?></td>
                        <td><?= esc(date('d/m/Y', strtotime($exam['CreatedAt']))); ?></td>
                        <td><?= esc($exam['Status']); ?></td>
                        <td><?= esc($exam['StatusQuestions']); ?></td>
                        <td><?= esc($exam['DurationTime']); ?> minutos</td>

                        <td>
                            <div class="row">
                                <form method="post" action="<?= site_url('test/startTest') ?>">
                                <input type="hidden" name="testId" value="<?= $exam['PK_Test'] ?>">
                                <input type="hidden" name="userId" value="<?= session()->get('PK_User') ?>">
                                <input type="hidden" name="groupId" value="<?= session()->get('FK_Group') ?>">
                                <input type="hidden" name="nameTest" value="<?= esc($exam['NameTest']) ?>">
                                <input type="hidden" name="description" value="<?= esc($exam['Description']) ?>">
                                <input type="hidden" name="durationTime" value="<?= esc($exam['DurationTime']) ?>">
                                    <button type="submit">Iniciar Examen</button>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="7">No se han encontrado exámenes asignados para tu grupo.</td>
                </tr>
            <?php endif; ?>

            </tbody>
        </table>
    </div>
</div>

    </section>

<?php endif; ?>


<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form method="post" action="<?php echo site_url('/test/AssignGroup'); ?>" id="meetForm">
                    <div class="modal-header">
                        <h4 class="modal-title" id="editModalLabel" style="text-align: left;">Asignar grupo</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close" onclick="ClearModal()">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="col-md-12 ml-auto mr-auto text-center">
                            <div class="form-group">
                                <input type="hidden" id="Id" name="Id">
                                <h3 id="TestName" class="font-weight-bold mb-2"></h3>
                                <h5 id="TestDescription" class="text-muted mb-1"></h5>
                            </div>
                            <div class="form-group">
                                <label for="group">Select Group</label>
                                <select name="groupId" id="groupId" class="form-control">
                                    <option value="">--Selecciona un grupo--</option>
                                    <?php if (!empty($group) && is_array($group)) : ?>
                                        <?php foreach ($group as $group) : ?>
                                            <option value="<?= esc($group['PK_Group']) ?>"><?= esc($group['GroupName']) ?></option>
                                        <?php endforeach; ?>
                                    <?php else : ?>
                                        <option value="">No groups available</option>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn">Guardar Cambios</button>
                        <button type="button" class="btn-close" data-dismiss="modal">Cerrar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</body>
</html>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
<script src="<?=base_url()?>js/dashboard/dashboard.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/js/bootstrap-select.min.js"></script>

<script>
    var baseUrl = "<?= base_url() ?>";
    var userId = "<?= session()->get('PK_User') ?>"; 
</script>

<script>
function editData(pk){
    $('#editModal').modal('show');
    $('#Id').val(pk);
}
</script>

<script>
$(document).ready(function() {
    $('#groupsTable').DataTable({
        responsive: true 
    });

    $('#testsTable').DataTable({
        responsive: true 
    });

    $('#testsStudentsTable').DataTable({
        responsive: true 
    });
});
</script>

<script>
    document.querySelectorAll('form').forEach(function(form) {
        form.addEventListener('submit', function(event) {
            // Imprimir los valores del formulario en la consola
            let formData = new FormData(form);
            for (var pair of formData.entries()) {
                console.log(pair[0] + ': ' + pair[1]); // Imprime todos los valores del formulario
            }

            // Quitar el event.preventDefault() para permitir que el formulario se envíe
            // event.preventDefault(); // Esto se puede quitar o condicionar si es necesario

            // Si quieres que se envíe solo cuando todo está correcto
            // form.submit(); // Esto enviará el formulario
        });
    });
</script>


<script>
    function assignQuestions(testId) {
        // Crear un formulario temporal para enviar los datos por POST
        var form = document.createElement("form");
        form.method = "POST";
        form.action = "<?= site_url('/questions/assign') ?>";

        // Crear un campo oculto para el testId
        var input = document.createElement("input");
        input.type = "hidden";
        input.name = "testId";
        input.value = testId;
        form.appendChild(input);

        // Añadir el formulario al body y enviarlo
        document.body.appendChild(form);
        form.submit();
    }
</script>


<script>
    function ClearModal(){
        $('#Id').val('');
        $('#TestName').text('');
        $('#TestDescription').text('');
    }
</script>

<script>
        document.addEventListener('DOMContentLoaded', function () {
            <?php if (session()->getFlashdata('success')): ?>
                Swal.fire({
                    title: 'Exito!!',
                    text: '<?= session()->getFlashdata('success') ?>',
                    icon: 'success',
                    confirmButtonText: 'OK'
                });
            <?php endif; ?>

            <?php if (session()->getFlashdata('error')): ?>
                Swal.fire({
                    title: 'Error!',
                    text: '<?= session()->getFlashdata('error') ?>',
                    icon: 'error',
                    confirmButtonText: 'OK'
                });
            <?php endif; ?>
            <?php if (session()->getFlashdata('info')): ?>
                Swal.fire({
                    title: 'Error!',
                    text: '<?= session()->getFlashdata('info') ?>',
                    icon: 'info',
                    confirmButtonText: 'OK'
                });
            <?php endif; ?>
        });
    </script>

