// Función para abrir el modal de cambiar contraseña
function openPasswordModal(ticketId) {
    document.getElementById('ticketId').value = ticketId; // Asignar el ticketId al campo hidden
    document.getElementById('passwordModal').style.display = 'block'; // Mostrar el modal
}

// Función para cerrar el modal de cambiar contraseña
function closePasswordModal() {
    document.getElementById('passwordModal').style.display = 'none'; // Ocultar el modal
}

// Manejar el envío del formulario para cambiar la contraseña
document.getElementById('changePasswordForm').addEventListener('submit', async function(event) {
    event.preventDefault();

    const ticketId = document.getElementById('ticketId').value;
    const newPassword = document.getElementById('newPassword').value;

    try {
        const response = await fetch(baseUrl + '/tickets/changePassword', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify({
                ticketId: ticketId,
                newPassword: newPassword
            })
        });
        const data = await response.json();

        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'Éxito',
                text: data.message
            }).then(() => {
                location.reload();
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: data.message
            });
        }
    } catch (error) {
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Hubo un error al procesar tu solicitud.'
        });
    }
});


// Función para abrir el modal de marcar como resuelto
function openResolveModal(ticketId) {
    document.getElementById('resolveTicketId').value = ticketId; // Asegurarse de que el ticketId se está asignando correctamente
    document.getElementById('resolveModal').style.display = 'block';
}

// Función para cerrar el modal de marcar como resuelto
function closeResolveModal() {
    document.getElementById('resolveModal').style.display = 'none';
}

// Manejar el envío del formulario para marcar como resuelto
document.getElementById('resolveTicketForm').addEventListener('submit', function(event) {
    event.preventDefault();

    const ticketId = document.getElementById('resolveTicketId').value;

    fetch(baseUrl + '/tickets/resolve', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: JSON.stringify({
            resolveTicketId: ticketId
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'Éxito',
                text: data.message
            }).then(() => {
                location.reload();
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: data.message
            });
        }
    })
    .catch(error => {
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Hubo un error al procesar tu solicitud.'
        });
    });
});

// Generar contraseña segura
function generatePassword() {
    const length = 12;
    const charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()";
    let password = "";
    for (let i = 0, n = charset.length; i < length; ++i) {
        password += charset.charAt(Math.floor(Math.random() * n));
    }
    document.getElementById('newPassword').value = password;
}

// Copiar contraseña al portapapeles (con compatibilidad moderna)
function copyPassword() {
    const passwordField = document.getElementById('newPassword');
    const password = passwordField.value;

    // Intentar copiar usando la API moderna
    if (navigator.clipboard) {
        navigator.clipboard.writeText(password).then(function() {
            Swal.fire({
                icon: 'success',
                title: 'Contraseña copiada',
                text: 'La nueva contraseña ha sido copiada al portapapeles'
            });
        }).catch(function(error) {
            console.error('Error al copiar la contraseña: ', error);
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'No se pudo copiar la contraseña'
            });
        });
    } else {
        // Fallback para navegadores que no soportan `navigator.clipboard`
        passwordField.select();
        document.execCommand('copy');
        Swal.fire({
            icon: 'success',
            title: 'Contraseña copiada',
            text: 'La nueva contraseña ha sido copiada al portapapeles'
        });
    }
}
