document.addEventListener('DOMContentLoaded', function () {
    const btn = document.getElementById("requestPasswordChange");

    btn.onclick = function () {
        // Verificar si ya existe un ticket pendiente
        fetch(baseUrl + '/settings/checkPendingPasswordRequest', {  // Nueva ruta para verificación
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify({
                FK_User: userId  // Enviar el PK_User
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.hasPendingRequest) {
                // Si ya tiene una solicitud pendiente, mostrar alerta
                Swal.fire({
                    icon: 'info',
                    title: 'Solicitud ya enviada',
                    text: 'Ya tienes una solicitud de cambio de contraseña pendiente. Espera hasta que sea procesada.',
                });
            } else {
                // Si no hay una solicitud pendiente, enviar una nueva
                sendPasswordChangeRequest();
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Hubo un problema al verificar tu solicitud. Inténtalo más tarde.',
            });
        });
    };

    // Función para enviar la solicitud de cambio de contraseña
    function sendPasswordChangeRequest() {
        fetch(baseUrl + '/settings/createChangePasswordTicket', {  // Ruta para crear el ticket
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify({
                FK_User: userId,  // Enviar el PK_User
                Category: 'Cambio de Contraseña',
                Priority: 'Alta',
                Reason: 'Solicito un cambio de contraseña' // Motivo estático
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Mostrar SweetAlert de éxito
                Swal.fire({
                    icon: 'success',
                    title: 'Solicitud enviada',
                    text: 'Tu solicitud de cambio de contraseña ha sido enviada. Espera hasta 24 horas para recibir una respuesta.',
                });

                // Deshabilitar el botón para indicar que ya ha sido enviado
                btn.disabled = true;
                btn.textContent = "Solicitud enviada";
            } else {
                // Mostrar alerta de error
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Hubo un problema al enviar tu solicitud o ya tienes una solicitud pendiente. Inténtalo más tarde.',
                });
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Hubo un problema al enviar tu solicitud o ya tienes una solicitud pendiente. Inténtalo más tarde.',
            });
        });
    }
});

document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById("updateContactInfo");

    form.addEventListener('submit', function(event) {
        event.preventDefault(); // Evita que el formulario se envíe normalmente

        // Obtener los valores de los campos email, phone y userId
        const email = document.getElementById('email').value;
        const phone = document.getElementById('phone').value;
        const userId = document.getElementById('userId').value; // Ahora obtenemos el userId del campo hidden

        // Enviar el ticket con la información de contacto
        fetch(baseUrl + '/settings/createContactTicket', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify({
                FK_User: userId,  // Enviar el PK_User desde el hidden
                email: email,
                phone: phone
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Mostrar alerta de éxito
                Swal.fire({
                    icon: 'success',
                    title: 'Información actualizada',
                    text: 'Tu información de contacto ha sido enviada correctamente.',
                });

                // Limpiar el formulario
                form.reset();
            } else {
                // Mostrar alerta de error
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: data.message || 'Hubo un problema al enviar la información.',
                });
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Hubo un problema al enviar la información.',
            });
        });
    });
});

document.addEventListener('DOMContentLoaded', function () {
    const supportBtn = document.getElementById("requestSupport");
    const supportModal = document.getElementById("supportModal");
    const closeModalBtn = document.getElementsByClassName("close")[0];
    const supportForm = document.getElementById("supportForm");

    // Abrir el modal
    supportBtn.onclick = function () {
        // Verificar si ya existe un ticket pendiente en las últimas 24 horas
        fetch(baseUrl + '/settings/checkSupportRequest', {  
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify({
                FK_User: document.getElementById('userId').value  // Enviar el PK_User desde el hidden
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.hasPendingRequest) {
                // Mostrar alerta si ya existe un ticket pendiente
                Swal.fire({
                    icon: 'info',
                    title: 'Solicitud ya enviada',
                    text: data.message,
                });
            } else {
                // Abrir el modal si no hay ticket pendiente
                supportModal.style.display = "block";
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Hubo un problema al verificar tu solicitud. Inténtalo más tarde.',
            });
        });
    };

    // Cerrar el modal al hacer clic en la "X"
    closeModalBtn.onclick = function () {
        supportModal.style.display = "none";
    };

    // Cerrar el modal al hacer clic fuera de él
    window.onclick = function (event) {
        if (event.target == supportModal) {
            supportModal.style.display = "none";
        }
    };

    // Manejar el envío del formulario de soporte
    supportForm.addEventListener('submit', function (event) {
        event.preventDefault();  // Evitar envío normal del formulario

        // Obtener el motivo del soporte y el ID de usuario
        const supportReason = document.getElementById('supportReason').value;
        const userId = document.getElementById('userId').value;  // Obtener el userId desde el hidden

        // Enviar la solicitud de soporte
        fetch(baseUrl + '/settings/createSupportTicket', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify({
                FK_User: userId,
                Category: 'Soporte',
                Priority: 'Media',
                supportReason: supportReason  // Enviar el motivo de soporte
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Mostrar SweetAlert de éxito
                Swal.fire({
                    icon: 'success',
                    title: 'Solicitud enviada',
                    text: data.message,
                });

                // Cerrar el modal y limpiar el formulario
                supportModal.style.display = "none";
                supportForm.reset();
            } else {
                // Mostrar alerta de error
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: data.message || 'Hubo un problema al enviar tu solicitud. Inténtalo más tarde.',
                });
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Hubo un problema al enviar tu solicitud. Inténtalo más tarde.',
            });
        });
    });
});
