document.addEventListener('DOMContentLoaded', function () {
    // Modal para añadir un grupo
    const addGroupModal = document.getElementById("addGroupModal");
    const openGroupModalBtn = document.getElementById("openGroupModal"); // Botón para abrir modal de grupo
    const closeGroupModalBtn = addGroupModal ? addGroupModal.getElementsByClassName("close")[0] : null;

    // Abrir modal al hacer clic en el botón de añadir grupo
    if (openGroupModalBtn) {
        openGroupModalBtn.onclick = function() {
            addGroupModal.style.display = "block";
        }
    }

    // Cerrar modal al hacer clic en la "X"
    if (closeGroupModalBtn) {
        closeGroupModalBtn.onclick = function() {
            addGroupModal.style.display = "none";
        }
    }

    // Cerrar modal si el usuario hace clic fuera del modal
    window.onclick = function(event) {
        if (event.target == addGroupModal) {
            addGroupModal.style.display = "none";
        }
    }

    document.getElementById('addGroupForm').addEventListener('submit', function (e) {
        e.preventDefault(); // Evitar el comportamiento por defecto del formulario

        // Obtener los valores del formulario
        var groupName = document.getElementById('groupName').value;
        var description = document.getElementById('description').value;

        // Asegúrate de que los campos no estén vacíos antes de enviarlos
        if (!groupName || !description) {
            Swal.fire('Error', 'Por favor, completa todos los campos', 'error');
            return;
        }

        // Enviar los datos al servidor
        fetch(`${baseUrl}/logicuser/createGroup`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify({
                GroupName: groupName,
                Description: description
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                Swal.fire('Éxito', 'Grupo creado exitosamente', 'success').then(() => {
                    location.reload(); // Recargar la página para reflejar los cambios
                });
            } else {
                Swal.fire('Error', data.message || 'Hubo un problema al crear el grupo', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire('Error', 'Ocurrió un error inesperado', 'error');
        });
    });
});

document.addEventListener('DOMContentLoaded', function () {
    let currentGroupPage = 1;
    const recordsPerPage = 5;
    let totalPages = 1;

    // Modal para gestionar (desactivar) grupos
    const deleteGroupModal = document.getElementById("deleteGroupModal");
    const openDeleteGroupModalBtn = document.getElementById("openDeleteGroupModal");
    const closeDeleteGroupModalBtn = deleteGroupModal ? deleteGroupModal.getElementsByClassName("close")[0] : null;

    // Abrir modal al hacer clic en el botón de gestionar grupos
    if (openDeleteGroupModalBtn) {
        openDeleteGroupModalBtn.onclick = function() {
            deleteGroupModal.style.display = "block";
            fetchGroupTable(currentGroupPage); // Cargar la tabla de grupos
        }
    }

    // Cerrar modal al hacer clic en la "X"
    if (closeDeleteGroupModalBtn) {
        closeDeleteGroupModalBtn.onclick = function() {
            deleteGroupModal.style.display = "none";
        }
    }

    // Cerrar modal si el usuario hace clic fuera del modal
    window.onclick = function(event) {
        if (event.target == deleteGroupModal) {
            deleteGroupModal.style.display = "none";
        }
    }

    // Función para cargar la tabla de grupos dentro del modal
    function fetchGroupTable(page) {
        fetch(`${baseUrl}/logicuser/getActiveGroups`, {
            method: 'GET',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const groupsList = document.querySelector('.groups-list-delete');
                groupsList.innerHTML = '';  // Limpiar la tabla antes de llenarla
                totalPages = Math.ceil(data.groups.length / recordsPerPage); // Calcular total de páginas

                const startIndex = (page - 1) * recordsPerPage;
                const endIndex = startIndex + recordsPerPage;
                const paginatedGroups = data.groups.slice(startIndex, endIndex);

                paginatedGroups.forEach(group => {
                    const row = document.createElement('tr');

                    const nameCell = document.createElement('td');
                    nameCell.textContent = group.GroupName;
                    nameCell.setAttribute('data-label', 'Nombre del Grupo');

                    const descriptionCell = document.createElement('td');
                    descriptionCell.textContent = group.Description;
                    descriptionCell.setAttribute('data-label', 'Descripción');

                    const actionCell = document.createElement('td');
                    const deleteButton = document.createElement('button');
                    deleteButton.textContent = 'Desactivar';
                    deleteButton.classList.add('delete-btn');
                    deleteButton.addEventListener('click', function() {
                        deactivateGroup(group.PK_Group);
                    });
                    actionCell.appendChild(deleteButton);
                    actionCell.setAttribute('data-label', 'Acción');

                    row.appendChild(nameCell);
                    row.appendChild(descriptionCell);
                    row.appendChild(actionCell);

                    groupsList.appendChild(row);
                });

                updatePaginationInfo();
            } else {
                console.error('No se encontraron grupos:', data.message);
            }
        })
        .catch(error => {
            console.error('Error al obtener los grupos:', error);
        });
    }

    // Actualizar información de paginación
    function updatePaginationInfo() {
        document.getElementById('pageInfo').textContent = `Página ${currentGroupPage} de ${totalPages}`;
        document.getElementById('prevPage').disabled = currentGroupPage === 1;
        document.getElementById('nextPage').disabled = currentGroupPage === totalPages;
    }

    // Botón "Anterior" en la paginación
    document.getElementById('prevPage').addEventListener('click', function() {
        if (currentGroupPage > 1) {
            currentGroupPage--;
            fetchGroupTable(currentGroupPage);
        }
    });

    // Botón "Siguiente" en la paginación
    document.getElementById('nextPage').addEventListener('click', function() {
        if (currentGroupPage < totalPages) {
            currentGroupPage++;
            fetchGroupTable(currentGroupPage);
        }
    });

    // Función para desactivar el grupo
    function deactivateGroup(groupId) {
        fetch(`${baseUrl}/logicuser/deactivateGroup/${groupId}`, {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                Swal.fire('Éxito', 'El grupo ha sido desactivado', 'success').then(() => {
                    fetchGroupTable(currentGroupPage);  // Volver a cargar la tabla de grupos
                });
            } else {
                Swal.fire('Error', data.message || 'Hubo un problema al desactivar el grupo', 'error');
            }
        })
        .catch(error => {
            console.error('Error al desactivar el grupo:', error);
            Swal.fire('Error', 'Hubo un problema con la solicitud', 'error');
        });
    }
});
