document.addEventListener('DOMContentLoaded', function () {
    // Abrir y cerrar modal
    const modal = document.getElementById("myModal");
    const btn = document.getElementById("openModal");
    const span = document.getElementsByClassName("close")[0];

    btn.onclick = function() {
        modal.style.display = "block";
    }

    span.onclick = function() {
        modal.style.display = "none";
    }

    window.onclick = function(event) {
        if (event.target == modal) {
            modal.style.display = "none";
        }
    }

    loadGroups();


    // Generar matrícula automáticamente cuando se ingresan nombre y apellido
    document.getElementById("name").addEventListener("input", generateMatricula);
    document.getElementById("lastName").addEventListener("input", generateMatricula);

    function generateMatricula() {
        const name = document.getElementById("name").value;
        const lastName = document.getElementById("lastName").value;
        const timestamp = Date.now().toString().slice(-5); 
        const matricula = `${name.substring(0, 3).toUpperCase()}${lastName.substring(0, 3).toUpperCase()}${timestamp}`;
        document.getElementById("matricula").value = matricula;
    }

    // Generar contraseñas aleatorias
    function generateRandomPassword(length = 10) {
        const chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()_+[]";
        let password = "";
        for (let i = 0; i < length; i++) {
            password += chars.charAt(Math.floor(Math.random() * chars.length));
        }
        return password;
    }

    document.getElementById("generatePassword").addEventListener("click", function() {
        const newPassword = generateRandomPassword(10); 

        Swal.fire({
            title: 'Contraseña Generada',
            text: newPassword,
            icon: 'info',
            showCancelButton: true,
            confirmButtonText: 'Copiar contraseña',
            cancelButtonText: 'Cerrar'
        }).then((result) => {
            if (result.isConfirmed) {
                navigator.clipboard.writeText(newPassword).then(function() {
                    Swal.fire('¡Copiado!', 'La contraseña se ha copiado al portapapeles.', 'success');
                }, function(err) {
                    Swal.fire('Error', 'No se pudo copiar la contraseña.', 'error');
                });

                document.getElementById("password").value = newPassword;
                document.getElementById("confirmPassword").value = newPassword;
            }
        });
    });

     // Cargar los grupos activos en el select
    function loadGroups() {
        fetch(baseUrl + 'logicuser/getActiveGroups', {
            method: 'GET',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => {
            return response.json();
        })
        .then(data => {
            if (data.success) {
                const groupSelect = document.getElementById('group');
                groupSelect.innerHTML = ''; // Limpiar opciones anteriores
                
                data.groups.forEach(group => {
                    const option = document.createElement('option');
                    option.value = group.PK_Group;
                    option.textContent = group.GroupName;
                    groupSelect.appendChild(option);
                });
            } else {
                console.error('No se encontraron grupos activos');
                Swal.fire('Error', 'No se encontraron grupos activos', 'error');
            }
        })
        .catch(error => {
            console.error('Error al cargar los grupos:', error);
            const groupSelect = document.getElementById('group');
            const option = document.createElement('option');
            option.value = 0;
            option.textContent = 'Sin grupos disponibles';
            groupSelect.appendChild(option);
        });
    }
    

    document.getElementById("addStudentForm").addEventListener("submit", function(event) {
        event.preventDefault();
        
        const submitButton = document.getElementById("createStudent");
        submitButton.disabled = true; 
        
        const password = document.getElementById("password").value;
        const confirmPassword = document.getElementById("confirmPassword").value;

        if (password !== confirmPassword) {
            Swal.fire('Error', 'Las contraseñas no coinciden', 'error');
            submitButton.disabled = false;
            return;
        }

        const formData = new FormData(document.getElementById('addStudentForm'));

        // Enviar los datos del formulario, incluyendo el grupo seleccionado
        fetch(baseUrl + 'users/create', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                Swal.fire('Éxito', 'Alumno creado exitosamente', 'success').then(() => {
                    location.reload();
                });
            } else {
                Swal.fire('Error', data.message || 'Hubo un problema al crear el alumno', 'error');
                submitButton.disabled = false;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire('Error', 'Hubo un problema con la solicitud', 'error');
            submitButton.disabled = false;
        });
    });
    
    
  // Función para obtener la lista de alumnos con FK_Rol = 1
function fetchLatestStudents() {
    fetch(baseUrl + '/logicuser/getUsersByRoleOne')
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const studentsList = document.querySelector('.students-list');
                studentsList.innerHTML = '';

                data.users.forEach(user => {
                    const listItem = document.createElement('li');
                    const studentItem = document.createElement('div');
                    studentItem.classList.add('student-item');

                    const svgIcon = document.createElementNS("http://www.w3.org/2000/svg", "svg");
                    svgIcon.setAttribute("width", "20");
                    svgIcon.setAttribute("height", "20");
                    const useElement = document.createElementNS("http://www.w3.org/2000/svg", "use");
                    useElement.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#users");
                    svgIcon.appendChild(useElement);

                    const studentName = document.createElement('span');
                    studentName.textContent = `${user.Name} ${user.LastName}`;

                    studentItem.appendChild(svgIcon);
                    studentItem.appendChild(studentName);

                    listItem.appendChild(studentItem);
                    studentsList.appendChild(listItem);
                });
            } else {
                console.error('No se encontraron alumnos:', data.message);
            }
        })
        .catch(error => {
            console.error('Error al obtener los alumnos:', error);
        });
}

// Llamar a la función para obtener los alumnos cuando la página se cargue
fetchLatestStudents();

    // Abrir y cerrar modal de dar de baja alumnos
    const deleteModal = document.getElementById("deleteStudentModal");
    const openDeleteBtn = document.getElementById("openDeleteModal");
    const closeDeleteSpan = deleteModal.getElementsByClassName("close")[0];

    openDeleteBtn.onclick = function() {
        deleteModal.style.display = "block";
        fetchStudentTable(); // Llamar a la función para llenar la tabla
    }

    closeDeleteSpan.onclick = function() {
        deleteModal.style.display = "none";
    }

    window.onclick = function(event) {
        if (event.target == deleteModal) {
            deleteModal.style.display = "none";
        }
    }

    let currentPage = 1;
const recordsPerPage = 5;

// Función para cargar la tabla de alumnos dentro del modal
function fetchStudentTable() {
    fetch(baseUrl + '/logicuser/getUsersByRoleOne')
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const studentsList = document.querySelector('.students-list-delete');
                const totalRecords = data.users.length;
                const totalPages = Math.ceil(totalRecords / recordsPerPage);

                // Función para renderizar una página
                function renderPage(page) {
                    studentsList.innerHTML = '';

                    // Cálculo de índice de registros
                    const start = (page - 1) * recordsPerPage;
                    const end = start + recordsPerPage;
                    const paginatedUsers = data.users.slice(start, end);

                    // Renderizar cada usuario en la página actual
                    paginatedUsers.forEach(user => {
                        const row = document.createElement('tr');

                        const matriculaCell = document.createElement('td');
                        matriculaCell.textContent = user.Matricula;
                        matriculaCell.setAttribute('data-label', 'Matrícula'); // Para móviles

                        const nameCell = document.createElement('td');
                        nameCell.textContent = `${user.Name} ${user.LastName}`;
                        nameCell.setAttribute('data-label', 'Nombre'); // Para móviles

                        const actionCell = document.createElement('td');
                        const deleteButton = document.createElement('button');
                        deleteButton.textContent = 'Dar de baja';
                        deleteButton.classList.add('delete-btn');
                        deleteButton.addEventListener('click', function() {
                            // Lógica para dar de baja al alumno
                            removeStudent(user.PK_User);
                        });
                        actionCell.appendChild(deleteButton);
                        actionCell.setAttribute('data-label', 'Acción'); // Para móviles

                        row.appendChild(matriculaCell);
                        row.appendChild(nameCell);
                        row.appendChild(actionCell);

                        studentsList.appendChild(row);
                    });

                    // Renderizar los botones de paginación
                    renderPagination(totalPages, page);
                }

                // Función para renderizar la paginación
                function renderPagination(totalPages, currentPage) {
                    const paginationContainer = document.querySelector('.pagination');
                    paginationContainer.innerHTML = '';

                    // Botón de página anterior
                    const prevButton = document.createElement('button');
                    prevButton.textContent = 'Anterior';
                    prevButton.disabled = currentPage === 1;
                    prevButton.addEventListener('click', () => {
                        currentPage--;
                        renderPage(currentPage);
                    });
                    paginationContainer.appendChild(prevButton);

                    // Botón de página siguiente
                    const nextButton = document.createElement('button');
                    nextButton.textContent = 'Siguiente';
                    nextButton.disabled = currentPage === totalPages;
                    nextButton.addEventListener('click', () => {
                        currentPage++;
                        renderPage(currentPage);
                    });
                    paginationContainer.appendChild(nextButton);
                }

                // Renderizar la primera página
                renderPage(currentPage);
            } else {
                console.error('No se encontraron alumnos:', data.message);
            }
        })
        .catch(error => {
            console.error('Error al obtener los alumnos:', error);
        });
}

// Función para dar de baja al alumno
function removeStudent(studentId) {
    fetch(baseUrl + `/users/deactivate/${studentId}`, {
        method: 'POST',
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire('Éxito', 'El alumno ha sido dado de baja', 'success').then(() => {
                location.reload(); // Recargar la página después de la alerta
            });
        } else {
            Swal.fire('Error', data.message || 'Hubo un problema al dar de baja al alumno', 'error');
        }
    })
    .catch(error => {
        console.error('Error al dar de baja al alumno:', error);
        Swal.fire('Error', 'Hubo un problema con la solicitud', 'error');
    });
}

});

document.addEventListener('DOMContentLoaded', function() {
    const modal = document.getElementById('modalAvisoPrivacidad');
    const openModalBtn = document.getElementById('openPrivacyModal');
    const closeModalBtn = document.querySelector('#modalAvisoPrivacidad .close');

    openModalBtn.onclick = function() {
    modal.style.display = 'block';
    };

    closeModalBtn.onclick = function() {
    modal.style.display = 'none';
    };

    window.onclick = function(event) {
    if (event.target == modal) {
        modal.style.display = 'none';
    }
    };
});
