function enableEdit(button) {
    // Encuentra la tarjeta a la que corresponde el botón de edición
    event.preventDefault();
    const card = button.closest('.card');
    
    // Encuentra todos los <h4> en el cuerpo de la tarjeta
    const fields = card.querySelectorAll('input');
    
    // Cambia cada <h4> por un campo de entrada editable
    fields.forEach(field => {
        field.removeAttribute('disabled');
    });
    
    // Ocultar el botón de edición y mostrar el botón de guardar
    button.style.display = 'none';
    card.querySelector('.save-button').style.display = 'inline-block';
}

var toastMixin = Swal.mixin({
    toast: true,
    icon: 'success',
    title: 'General Title',
    animation: false,
    position: 'top-right',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
});

