  // Manejo de modales
  function openEditModal(materialId) {
    document.getElementById('editMaterialId').value = materialId;
    document.getElementById('editModal').style.display = 'block';
}

function closeEditModal() {
    document.getElementById('editModal').style.display = 'none';
}

function openDeleteModal(materialId) {
    document.getElementById('deleteMaterialId').value = materialId;
    document.getElementById('deleteModal').style.display = 'block';
}

function closeDeleteModal() {
    document.getElementById('deleteModal').style.display = 'none';
}

document.getElementById('editMaterialForm').addEventListener('submit', function(event) {
event.preventDefault();
const materialId = document.getElementById('editMaterialId').value;
const name = document.getElementById('editName').value;
const link = document.getElementById('editLink').value;
const group = document.getElementById('editGroup').value;

// Petición para editar el material
fetch(baseUrl + '/material/update/' + materialId, {
    method: 'POST',
    headers: {
        'Content-Type': 'application/x-www-form-urlencoded',
        'X-Requested-With': 'XMLHttpRequest'
    },
    body: new URLSearchParams({
        name: name,
        link: link,
        group: group
    })
})
.then(response => response.json())
.then(data => {
    if (data.success) {
        Swal.fire({
            icon: 'success',
            title: 'Éxito',
            text: data.message,
            confirmButtonText: 'OK'
        }).then(() => {
            location.reload(); // Recargar la página
        });
    } else {
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: data.message,
            confirmButtonText: 'OK'
        });
    }
})
.catch(error => {
    Swal.fire({
        icon: 'error',
        title: 'Error',
        text: 'Hubo un error al procesar tu solicitud.',
        confirmButtonText: 'OK'
    });
});
});


document.getElementById('deleteMaterialForm').addEventListener('submit', function(event) {
event.preventDefault();
const materialId = document.getElementById('deleteMaterialId').value;

// Petición para eliminar el material
fetch(baseUrl + '/material/delete/' + materialId, {
    method: 'POST',
    headers: {
        'Content-Type': 'application/json',
        'X-Requested-With': 'XMLHttpRequest'
    }
})
.then(response => response.json())
.then(data => {
    if (data.success) {
        Swal.fire({
            icon: 'success',
            title: 'Éxito',
            text: data.message,
            confirmButtonText: 'OK'
        }).then(() => {
            location.reload(); // Recargar la página
        });
    } else {
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: data.message,
            confirmButtonText: 'OK'
        });
    }
})
.catch(error => {
    Swal.fire({
        icon: 'error',
        title: 'Error',
        text: 'Hubo un error al procesar tu solicitud.',
        confirmButtonText: 'OK'
    });
});
});

function openCreateModal() {
    document.getElementById('createModal').style.display = 'block';
}

function closeCreateModal() {
    document.getElementById('createModal').style.display = 'none';
}

// Manejar el envío del formulario para crear un nuevo material
document.getElementById('createMaterialForm').addEventListener('submit', function(event) {
    event.preventDefault();

    const name = document.getElementById('createName').value;
    const link = document.getElementById('createLink').value;
    const group = document.getElementById('createGroup').value;

    // Simulación de la petición para crear un nuevo material
    fetch(baseUrl + '/material/store', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: JSON.stringify({ name: name, link: link, group: group })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'Éxito',
                text: 'Material creado correctamente',
                confirmButtonText: 'OK'
            }).then(() => {
                location.reload(); // Recargar la página
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Hubo un problema al crear el material',
                confirmButtonText: 'OK'
            });
        }
    })
    .catch(error => {
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Hubo un error al procesar tu solicitud.',
            confirmButtonText: 'OK'
        });
    });
});
