document.addEventListener("DOMContentLoaded", function () { 
   // Modal y botones
    var modal = document.getElementById('addClassModal');
    var openModalButton = document.getElementById('openModal');
    var closeModalButton = document.getElementsByClassName('close')[0];

    loadGroups();


   // Abrir modal al hacer clic en el botón
    openModalButton.onclick = function() {
    modal.style.display = "block";
    }

   // Cerrar modal al hacer clic en la "X"
    closeModalButton.onclick = function() {
        modal.style.display = "none";
    }

   // Cerrar modal si el usuario hace clic fuera del modal
    window.onclick = function(event) {
        if (event.target == modal) {
            modal.style.display = "none";
        }
    }

    // Filtro de búsqueda de clases grabadas
    document.getElementById('searchInput').addEventListener('keyup', function () {
        let input = this.value.toLowerCase();
        let cards = document.querySelectorAll('.card');

        cards.forEach(function (card) {
            let title = card.querySelector('h3').textContent.toLowerCase();
            if (title.indexOf(input) > -1) {
                card.style.display = "";
            } else {
                card.style.display = "none";
            }
        });
    });
});

  // Enviar el formulario para agregar una clase
document.getElementById('addClassForm').addEventListener('submit', function(e) {
    e.preventDefault();

    var className = document.getElementById('className').value;
    var link = document.getElementById('link').value;
    var group = document.getElementById('group').value;

    fetch(`${baseUrl}/material/recordedclasses/add`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: JSON.stringify({
            className: className,
            link: link,
            group: group
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                title: 'Clase Añadida',
                text: 'Clase añadida exitosamente.',
                icon: 'success'
            }).then(() => {
                location.reload();
            });
        } else {
            Swal.fire('Error', 'Hubo un problema al añadir la clase', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        Swal.fire('Error', 'Ocurrió un error inesperado', 'error');
    });
});

   // Cargar los grupos activos en el select
function loadGroups() {
    fetch(baseUrl + 'logicuser/getActiveGroups', {
        method: 'GET',
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => {
        return response.json();
    })
    .then(data => {
        if (data.success) {
            const groupSelect = document.getElementById('group');
            groupSelect.innerHTML = ''; // Limpiar opciones anteriores
            
            data.groups.forEach(group => {
                const option = document.createElement('option');
                option.value = group.PK_Group;
                option.textContent = group.GroupName;
                groupSelect.appendChild(option);
            });
        } else {
            console.error('No se encontraron grupos activos');
            Swal.fire('Error', 'No se encontraron grupos activos', 'error');
        }
    })
    .catch(error => {
        console.error('Error al cargar los grupos:', error);
        const groupSelect = document.getElementById('group');
        const option = document.createElement('option');
        option.value = 0;
        option.textContent = 'Sin grupos disponibles';
        groupSelect.appendChild(option);
    });
}

// Función para eliminar una clase grabada
function deleteClass(id) {
    // Mostrar el SweetAlert de confirmación
    Swal.fire({
        title: '¿Estás seguro?',
        text: "¡No podrás revertir esta acción!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            // Llamada AJAX para eliminar la clase
            fetch(`${baseUrl}/material/recordedclasses/delete/${id}`, {
                method: 'GET',
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Mostrar alerta de éxito
                    Swal.fire({
                        title: 'Eliminado',
                        text: 'Clase eliminada con éxito.',
                        icon: 'success',
                        confirmButtonColor: '#3085d6'
                    }).then(() => {
                        // Recargar la página para reflejar los cambios
                        location.reload();
                    });
                } else {
                    // Mostrar alerta de error
                    Swal.fire({
                        title: 'Error',
                        text: 'Hubo un problema al eliminar la clase.',
                        icon: 'error',
                        confirmButtonColor: '#3085d6'
                    });
                }
            })
            .catch(error => {
                console.error('Error:', error);
                // Mostrar alerta de error en caso de fallo de red
                Swal.fire({
                    title: 'Error',
                    text: 'Hubo un problema con la solicitud.',
                    icon: 'error',
                    confirmButtonColor: '#3085d6'
                });
            });
        }
    });



}
