function showNextForm() {
    const questionType = document.getElementById('questionType').value;

    // Ocultar todos los formularios al inicio
    document.getElementById('captureResponseForm').style.display = 'none';
    document.getElementById('multipleOptionsForm').style.display = 'none';
    document.getElementById('findErrorForm').style.display = 'none';
    document.getElementById('grammarForm').style.display = 'none';
    document.getElementById('mathForm').style.display = 'none';
    document.getElementById('categoryQuestionForm').style.display = 'none';
    document.getElementById('timeline').style.display = 'none';
    document.getElementById('timeline_questions').style.display = 'none';
    document.getElementById('openModalButton').style.display = 'none';
    document.getElementById('multipleCorrectForm').style.display = 'none';
    
    

    // Mostrar el formulario correspondiente
    if (questionType === 'captura_respuesta') {
        document.getElementById('captureResponseForm').style.display = 'block';
    } else if (questionType === 'multiple_opciones') {
        document.getElementById('multipleOptionsForm').style.display = 'block';
    } else if (questionType === 'encuentra_error') {
        document.getElementById('findErrorForm').style.display = 'block';
    } else if (questionType === 'Gramatica') {
        document.getElementById('grammarForm').style.display = 'block'; 
    }else if (questionType === 'Matematicas') {
        document.getElementById('mathForm').style.display = 'block'; 
    }else if (questionType === 'Categorias') {
        document.getElementById('categoryQuestionForm').style.display = 'block'; 
    }else if (questionType === 'timeline' ){
        document.getElementById('timeline').style.display = 'block';
        document.getElementById('timeline_questions').style.display = 'block';
        document.getElementById('openModalButton').style.display = 'block';
    }else if (questionType === 'multiple_Correct') {
        document.getElementById('multipleCorrectForm').style.display = 'block';
    }
}


document.getElementById('captureResponseForm').addEventListener('submit', function(e) {
    e.preventDefault(); // Prevenir el comportamiento por defecto del formulario

    const formData = new FormData(this); // Crear un objeto FormData para enviar el archivo

    // Desactivar el botón de envío
    const submitButton = document.querySelector('#captureResponseForm button[type="submit"]');
    submitButton.disabled = true;
    submitButton.textContent = 'Procesando...';

    // Enviar la solicitud AJAX usando las rutas definidas en el script PHP
    fetch(createCaptureQuestionURL, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                title: '¡Éxito!',
                text: 'Pregunta creada exitosamente.',
                icon: 'success',
                showCancelButton: true,
                confirmButtonText: 'Añadir otra pregunta',
                cancelButtonText: 'Finalizar'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Limpiar los campos del formulario para crear otra pregunta
                    document.getElementById('captureResponseForm').reset();
                } else {
                    // Redirigir a otra página o finalizar
                    window.location.href = testURL;
                }
            });

            // Reactivar el botón de envío
            submitButton.disabled = false;
            submitButton.textContent = 'Enviar';

        } else {
            Swal.fire({
                title: 'Error',
                text: 'Hubo un error al crear la pregunta: ' + data.error,
                icon: 'error'
            });
            // Reactivar el botón de envío en caso de error
            submitButton.disabled = false;
            submitButton.textContent = 'Enviar';
        }
    })
    .catch(error => {
        Swal.fire({
            title: 'Error',
            text: 'Hubo un error al procesar la solicitud.',
            icon: 'error'
        });
        submitButton.disabled = false;
        submitButton.textContent = 'Enviar';
    });
});
document.getElementById('grammarForm').addEventListener('submit', function(e) {
    e.preventDefault(); // Prevenir el comportamiento por defecto del formulario

    const formData = new FormData(this); // Crear un objeto FormData para enviar los datos del formulario

    // Desactivar el botón de envío
    const submitButton = document.querySelector('#grammarForm button[type="submit"]');
    submitButton.disabled = true;
    submitButton.textContent = 'Procesando...';

    // Enviar la solicitud AJAX usando la ruta definida en el archivo PHP
    fetch(createGrammarQuestionURL, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                title: '¡Éxito!',
                text: 'Pregunta gramatical creada exitosamente.',
                icon: 'success',
                showCancelButton: true,
                confirmButtonText: 'Añadir otra pregunta',
                cancelButtonText: 'Finalizar'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Limpiar los campos del formulario para crear otra pregunta
                    document.getElementById('grammarForm').reset();
                } else {
                    // Redirigir a otra página o finalizar
                    window.location.href = testURL;
                }
            });

            // Reactivar el botón de envío
            submitButton.disabled = false;
            submitButton.textContent = 'Enviar';

        } else {
            Swal.fire({
                title: 'Error',
                text: 'Hubo un error al crear la pregunta: ' + data.error,
                icon: 'error'
            });
            // Reactivar el botón de envío en caso de error
            submitButton.disabled = false;
            submitButton.textContent = 'Enviar';
        }
    })
    .catch(error => {
        Swal.fire({
            title: 'Error',
            text: 'Hubo un error al procesar la solicitud.',
            icon: 'error'
        });
        submitButton.disabled = false;
        submitButton.textContent = 'Enviar';
    });
});

document.getElementById('mathForm').addEventListener('submit', function(e) {
    e.preventDefault(); // Prevenir el comportamiento por defecto del formulario

    const formData = new FormData(this); // Crear un objeto FormData para enviar los datos del formulario

    // Desactivar el botón de envío
    const submitButton = document.querySelector('#mathForm button[type="submit"]');
    submitButton.disabled = true;
    submitButton.textContent = 'Procesando...';

    // Enviar la solicitud AJAX usando la ruta definida en el archivo PHP
    fetch(createMathQuestionURL, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                title: '¡Éxito!',
                text: 'Pregunta de matemáticas creada exitosamente.',
                icon: 'success',
                showCancelButton: true,
                confirmButtonText: 'Añadir otra pregunta',
                cancelButtonText: 'Finalizar'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Limpiar los campos del formulario para crear otra pregunta
                    document.getElementById('mathForm').reset();
                } else {
                    // Redirigir a otra página o finalizar
                    window.location.href = testURL;
                }
            });

            // Reactivar el botón de envío
            submitButton.disabled = false;
            submitButton.textContent = 'Enviar';

        } else {
            Swal.fire({
                title: 'Error',
                text: 'Hubo un error al crear la pregunta: ' + data.error,
                icon: 'error'
            });
            // Reactivar el botón de envío en caso de error
            submitButton.disabled = false;
            submitButton.textContent = 'Enviar';
        }
    })
    .catch(error => {
        Swal.fire({
            title: 'Error',
            text: 'Hubo un error al procesar la solicitud.',
            icon: 'error'
        });
        submitButton.disabled = false;
        submitButton.textContent = 'Enviar';
    });
});

// Evento para el envío del formulario
document.getElementById('categoryQuestionForm').addEventListener('submit', function(e) {
    e.preventDefault();

    const formData = new FormData(this);

    const submitButton = document.querySelector('#categoryQuestionForm button[type="submit"]');
    submitButton.disabled = true;
    submitButton.textContent = 'Procesando...';

    fetch(createCategoryQuestionURL, {
        method: 'POST',
        body: formData
    })    
    
    .then(response => response.json())
    .then(data => {
        console.log(data);  // Aquí deberías ver la respuesta completa del servidor
        if (data.success) {
            Swal.fire({
                title: '¡Éxito!',
                text: data.message,
                icon: 'success',
                showCancelButton: true,
                confirmButtonText: 'Añadir otra pregunta',
                cancelButtonText: 'Finalizar'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('categoryQuestionForm').reset();
                    document.querySelectorAll('.items-container').forEach(container => container.innerHTML = '<input type="text" name="' + container.id + '[]" class="form-control">');
                } else {
                    window.location.href = '<?= site_url("tests/view") ?>';
                }
            });
        } else {
            Swal.fire('Error', data.error, 'error');
        }
        submitButton.disabled = false;
        submitButton.textContent = 'Enviar';
    })
    .catch(error => {
        Swal.fire('Error', 'Hubo un problema en el procesamiento de la solicitud.', 'error');
        submitButton.disabled = false;
        submitButton.textContent = 'Enviar';
    });
});


document.addEventListener('DOMContentLoaded', function() {
    // Obtener el botón para agregar respuestas correctas
    const addCorrectAnswerButton = document.getElementById('addCorrectAnswer');
    const correctAnswersContainer = document.getElementById('correctAnswersContainer');

    // Manejar el clic del botón para agregar una nueva respuesta correcta
    addCorrectAnswerButton.addEventListener('click', function() {
        // Crear un nuevo grupo de respuesta correcta
        const newAnswerGroup = document.createElement('div');
        newAnswerGroup.classList.add('correct-answer-group');
        
        // Crear un nuevo campo de entrada
        const newInput = document.createElement('input');
        newInput.type = 'text';
        newInput.name = 'correctAnswer[]'; // Asegúrate de usar el mismo nombre para que el backend lo reconozca como un array
        newInput.classList.add('form-control');
        newInput.required = true; // Puedes quitar esto si no quieres que sean obligatorios
        
        // Agregar el campo de entrada al nuevo grupo
        newAnswerGroup.appendChild(newInput);
        // Agregar el nuevo grupo al contenedor
        correctAnswersContainer.appendChild(newAnswerGroup);
    });
});